/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigInteger;

public class SGVetter {
    private static final long MINIMUM_CACHED_VALUE_COUNT = 1L;
    private boolean _CAN_CYCLE;
    private BigInteger _STEP;
    private BigInteger _MAX;
    private BigInteger _MIN;
    private BigInteger _RESTART;
    private long _ALLOCATION_COUNT;
    private boolean _INCREASING;
    private BigInteger _currentValue;
    private long _valuesRemaining;
    private BigInteger _upperBound;

    public SGVetter(Long l, boolean bl, long l2, long l3, long l4, long l5, long l6) throws Exception {
        if (l2 >= l3) {
            throw new IllegalArgumentException();
        }
        if (l2 <= l4) {
            throw new IllegalArgumentException();
        }
        if (l5 > l3) {
            throw new IllegalArgumentException();
        }
        if (l5 < l4) {
            throw new IllegalArgumentException();
        }
        if (l != null) {
            if (l > l3) {
                throw new IllegalArgumentException();
            }
            if (l < l4) {
                throw new IllegalArgumentException();
            }
        }
        this._currentValue = l == null ? null : BigInteger.valueOf(l);
        this._CAN_CYCLE = bl;
        this._STEP = BigInteger.valueOf(l2);
        this._MAX = BigInteger.valueOf(l3);
        this._MIN = BigInteger.valueOf(l4);
        this._RESTART = BigInteger.valueOf(l5);
        this._ALLOCATION_COUNT = l6;
        this._INCREASING = this._STEP.compareTo(BigInteger.valueOf(0L)) > 0;
        this._upperBound = this._currentValue;
        this._valuesRemaining = 1L;
    }

    public Long getNextValue() {
        if (this._currentValue == null) {
            return null;
        }
        BigInteger bigInteger = this.cloneBigInteger(this._currentValue);
        this.advance();
        return bigInteger.longValue();
    }

    public Long getUpperBound() {
        if (this._upperBound == null) {
            return null;
        }
        return this._upperBound.longValue();
    }

    private void advance() {
        boolean bl;
        BigInteger bigInteger = this.bump(this._currentValue);
        boolean bl2 = bl = bigInteger.compareTo(this._currentValue) == 0;
        if (bl && !this._CAN_CYCLE) {
            this._currentValue = null;
            this._upperBound = null;
            return;
        }
        --this._valuesRemaining;
        if (this._valuesRemaining < 1L) {
            for (long i = 0L; i < this._ALLOCATION_COUNT; ++i) {
                this._upperBound = this.bump(this._upperBound);
            }
            this._valuesRemaining = this._ALLOCATION_COUNT;
        }
        this._currentValue = bigInteger;
    }

    private BigInteger bump(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.add(this._STEP);
        if (this.overflowed(bigInteger2)) {
            bigInteger2 = !this._CAN_CYCLE ? this.cloneBigInteger(bigInteger) : this._RESTART;
        }
        return bigInteger2;
    }

    private boolean overflowed(BigInteger bigInteger) {
        boolean bl = this._INCREASING ? bigInteger.compareTo(this._MAX) > 0 : bigInteger.compareTo(this._MIN) < 0;
        return bl;
    }

    private BigInteger cloneBigInteger(BigInteger bigInteger) {
        return new BigInteger(bigInteger.toByteArray());
    }
}

