/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DecryptDatabaseTest
extends BaseJDBCTestCase {
    private static final String TABLE = "DECRYPTTABLE";
    private static final String BOOTPW = "Thursday";
    private static final String ALREADY_BOOTED = "01J17";
    private static String encryptionAlgorithm;

    public DecryptDatabaseTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.connect(false, BOOTPW, null).close();
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("Did you change the boot password?", "XJ004", sqle);
            this.getConnection();
            this.saveEncryptionAlgorithm();
        }
        TestConfiguration tc = this.getTestConfiguration();
        tc.shutdownDatabase();
        try {
            this.connect(false, null, null);
            tc.shutdownDatabase();
            DecryptDatabaseTest.println("encrypting database (" + encryptionAlgorithm + ")");
            this.connect(false, BOOTPW, "dataEncryption=true;encryptionAlgorithm=" + encryptionAlgorithm);
            tc.shutdownDatabase();
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"database encryption failed");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XBM06", sqle);
        }
    }

    private void saveEncryptionAlgorithm() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values syscs_util.syscs_get_database_property('encryptionAlgorithm')");
        if (rs.next()) {
            String alg = rs.getString(1);
            if (alg != null && !alg.equals(encryptionAlgorithm)) {
                encryptionAlgorithm = alg;
            }
            DecryptDatabaseTest.assertFalse((boolean)rs.next());
        }
        rs.close();
        stmt.close();
    }

    public void testDecryptDatabaseNegative() throws SQLException {
        try {
            this.connect(false, "verywrongpw", null);
            DecryptDatabaseTest.fail((String)"connection succeeded with wrong password");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ040", sqle);
        }
        try {
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"connection succeeded without password");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XBM06", sqle);
        }
        try {
            this.connect(true, "verywrongpw", null);
            DecryptDatabaseTest.fail((String)"decryption succeeded with wrong password");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ040", sqle);
        }
        try {
            this.connect(true, null, null);
            DecryptDatabaseTest.fail((String)"decryption succeeded without password");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XBM06", sqle);
        }
        try {
            this.connect(true, null, null);
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XBM06", sqle);
        }
        try {
            this.connect(false, BOOTPW, "decryptDatabase=fred");
            DecryptDatabaseTest.fail((String)"bad decryptDatabase setting not detected");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ05B", sqle);
        }
        this.connect(false, BOOTPW, null);
    }

    public void testDecryptDatabase() throws SQLException {
        this.populateDatabase(true, 1000);
        this.getTestConfiguration().shutdownDatabase();
        Connection con = this.connect(true, BOOTPW, null);
        JDBC.assertNoWarnings(con.getWarnings());
        Statement stmt = con.createStatement();
        JDBC.assertDrainResults(stmt.executeQuery("select * from DECRYPTTABLE"), 1000);
        stmt.close();
        con.close();
        this.getTestConfiguration().shutdownDatabase();
        con = this.connect(false, null, null);
        stmt = con.createStatement();
        JDBC.assertDrainResults(stmt.executeQuery("select * from DECRYPTTABLE"), 1000);
        JDBC.assertFullResultSet(stmt.executeQuery("select * from DECRYPTTABLE where id <= 6 order by id ASC"), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}});
        stmt.close();
        con.close();
    }

    public void testDecryptOnBootedDatabase() throws SQLException {
        this.getConnection();
        DecryptDatabaseTest.println("Test warning 01J17");
        this.vetChangeWarning(this.connect(false, BOOTPW, "dataEncryption=true"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "newBootPassword=foo"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "newEncryptionKey=foo"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "decryptDatabase=true"));
        this.connect(true, BOOTPW, null).close();
        this.getTestConfiguration().shutdownDatabase();
        try {
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"decrypted already booted database");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XBM06", sqle);
        }
    }

    private void vetChangeWarning(Connection conn) throws SQLException {
        DecryptDatabaseTest.assertWarning(conn, ALREADY_BOOTED);
        conn.close();
    }

    public void testDecryptUnEncryptedDatabase() throws SQLException {
        Connection con = this.connect(true, BOOTPW, null);
        JDBC.assertNoWarnings(con.getWarnings());
        con.close();
        this.getTestConfiguration().shutdownDatabase();
        con = this.connect(true, null, null);
        con.close();
    }

    public void testConflictingConnectionAttributes() throws SQLException {
        try {
            this.connect(true, BOOTPW, "newBootPassword=MondayMilk");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (newBootPassword)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ048", sqle);
        }
        try {
            this.connect(true, BOOTPW, "newEncryptionKey=6162636465666768");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (newEncryptionKey)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ048", sqle);
        }
        try {
            this.connect(true, BOOTPW, "createFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (createFrom)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ081", sqle);
        }
        try {
            this.connect(true, BOOTPW, "restoreFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (restoreFrom)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ081", sqle);
        }
        try {
            this.connect(true, BOOTPW, "rollForwardRecoveryFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attrs (rollForwardRecoveryFrom)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ081", sqle);
        }
        this.connect(true, BOOTPW, null);
        this.getTestConfiguration().shutdownDatabase();
        try {
            this.connect(true, BOOTPW, "dataEncryption=true");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (dataEncryption)");
        }
        catch (SQLException sqle) {
            DecryptDatabaseTest.assertSQLState("XJ048", sqle);
        }
    }

    private Connection connect(boolean decrypt, String bootPassword, String otherAttrs) throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.clearStringBeanProperty(ds, "connectionAttributes");
        StringBuffer attrs = new StringBuffer();
        if (decrypt) {
            attrs.append("decryptDatabase=true").append(';');
        }
        if (bootPassword != null) {
            attrs.append("bootPassword=").append(bootPassword).append(';');
        }
        if (otherAttrs != null) {
            attrs.append(otherAttrs).append(';');
        }
        if (attrs.length() > 0) {
            JDBCDataSource.setBeanProperty(ds, "connectionAttributes", attrs.toString());
        }
        DecryptDatabaseTest.println("connectionAttributes: " + (attrs.length() == 0 ? "<empty>" : attrs.toString()));
        return ds.getConnection();
    }

    private void populateDatabase(boolean init, int rows) throws SQLException {
        this.setAutoCommit(false);
        DatabaseMetaData meta = this.getConnection().getMetaData();
        ResultSet rs = meta.getTables(null, null, TABLE, null);
        boolean hasTable = rs.next();
        DecryptDatabaseTest.assertFalse((boolean)rs.next());
        rs.close();
        if (init) {
            Statement stmt = this.createStatement();
            if (hasTable) {
                DecryptDatabaseTest.println("deleting rows from table DECRYPTTABLE");
                stmt.executeUpdate("delete from DECRYPTTABLE");
                DecryptDatabaseTest.println("resetting identity column");
                stmt.executeUpdate("ALTER TABLE DECRYPTTABLE ALTER COLUMN id RESTART WITH 1");
            } else {
                DecryptDatabaseTest.println("creating table DECRYPTTABLE");
                stmt.executeUpdate("create table DECRYPTTABLE (id int generated always as identity)");
            }
        }
        DecryptDatabaseTest.println("populating database");
        PreparedStatement ps = this.prepareStatement("insert into DECRYPTTABLE values (DEFAULT)");
        for (int i = 0; i < rows; ++i) {
            ps.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DecryptDatabaseTest suite");
        suite.addTest(DecryptDatabaseTest.wrapTest());
        suite.addTest(DecryptDatabaseTest.wrapTest("AES/OFB/NoPadding"));
        return suite;
    }

    private static Test wrapTest() {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(DecryptDatabaseTest.class), BOOTPW);
    }

    private static Test wrapTest(String encryptionMethod) {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(DecryptDatabaseTest.class), encryptionMethod, BOOTPW);
    }
}

