/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;

public class Derby6317Test
extends BaseJDBCTestCase {
    static final int DATABASE_SCALE = 1000000;
    static final int TABLE_ONE_ROW_COUNT = 1000000;
    static final int TABLE_THREE_ROW_COUNT = 8000000;
    static final int SELECT_ROWS_COUNT = 8000000;
    final String testSelect = "SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = ";

    public Derby6317Test(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Derby6317Test");
        baseTestSuite.addTest(Derby6317Test.baseSuite("Derby6317Test:embedded"));
        return baseTestSuite;
    }

    private void confirmIndexScanUsage(Statement statement, int n) throws SQLException {
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        boolean bl = runtimeStatisticsParser.usedConstraintForIndexScan("TABLE1");
        if (!bl) {
            Derby6317Test.assertTrue((String)("Should have done index scan but did table scan on TABLE1 for t0.Table3_ID = " + n), (boolean)bl);
        }
        if (!(bl = runtimeStatisticsParser.usedConstraintForIndexScan("TABLE2"))) {
            Derby6317Test.assertTrue((String)("Should have done index scan but did table scan on TABLE2 for t0.Table3_ID = " + n), (boolean)bl);
        }
    }

    public void testDERBY_6317_value1() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 5189284");
        this.confirmIndexScanUsage(statement, 5189284);
    }

    public void testDERBY_6317_value2() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6035610");
        this.confirmIndexScanUsage(statement, 6035610);
    }

    public void testDERBY_6317_value3() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6031628");
        this.confirmIndexScanUsage(statement, 6031628);
    }

    public void testDERBY_6317_value4() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 5189285");
        this.confirmIndexScanUsage(statement, 5189285);
    }

    public void testDERBY_6317_value6() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 6035609");
        this.confirmIndexScanUsage(statement, 6035609);
    }

    public void testDERBY_6317_value5() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = 1");
        this.confirmIndexScanUsage(statement, 1);
    }

    public void dontrun_testDERBY_6317() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        for (int i = 0; i < 8000000; ++i) {
            statement.execute("SELECT * FROM Table1 T1,Table2 t0 WHERE t1.ID = t0.Table1_ID and t0.Table3_ID = " + i);
            this.confirmIndexScanUsage(statement, i);
        }
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(Derby6317Test.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                int n2;
                Connection connection = statement.getConnection();
                statement.executeUpdate("CREATE TABLE Table1 (ID int PRIMARY KEY NOT NULL)");
                statement.executeUpdate("CREATE TABLE Table2 (Table1_ID int NOT NULL,Table3_ID int NOT NULL,CONSTRAINT TABLE2_PK PRIMARY KEY (Table1_ID,Table3_ID))");
                statement.executeUpdate("CREATE TABLE Table3 (ID int PRIMARY KEY NOT NULL)");
                statement.executeUpdate("ALTER TABLE table2 ADD CONSTRAINT TABLE2_FK_1 FOREIGN KEY (Table1_ID) REFERENCES TABLE1(ID)");
                statement.executeUpdate("ALTER TABLE table2 ADD CONSTRAINT TABLE2_FK_2 FOREIGN KEY (Table3_ID) REFERENCES TABLE3(ID)");
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT INTO table1 VALUES (?)");
                for (n2 = 0; n2 < 1000000; ++n2) {
                    preparedStatement.setInt(1, n2);
                    preparedStatement.execute();
                    if (n2 % 10000 != 0) continue;
                    connection.commit();
                }
                connection.commit();
                n2 = 8000000;
                preparedStatement = connection.prepareStatement("INSERT INTO table3 VALUES (?)");
                for (n = 0; n < n2; ++n) {
                    preparedStatement.setInt(1, n);
                    preparedStatement.execute();
                    if (n % 10000 != 0) continue;
                    connection.commit();
                }
                connection.commit();
                preparedStatement = connection.prepareStatement("INSERT INTO table2 VALUES (?,?)");
                int n3 = 0;
                for (n = 0; n < 1000000; ++n) {
                    preparedStatement.setInt(1, n);
                    int n4 = 0;
                    while (n4 < 8) {
                        preparedStatement.setInt(2, n3);
                        preparedStatement.execute();
                        ++n4;
                        ++n3;
                    }
                    if (n % 10000 != 0) continue;
                    connection.commit();
                }
                connection.commit();
            }
        };
    }
}

