/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class Tester2
extends TesterObject {
    public Tester2(String string) {
        super(string);
    }

    @Override
    public void startTesting() {
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            this.connex = this.getConnection();
            if (this.connex == null) {
                NsTest.logger.println("FAIL: " + this.getThread_id() + " could not get database connection");
                return;
            }
            try {
                this.connex.setAutoCommit(false);
            }
            catch (Exception exception) {
                NsTest.logger.println("FAIL: " + this.getThread_id() + "'s setAutoCommit() failed:");
                this.printException("setting AutoCommit in Tester2", exception);
                return;
            }
            this.setIsolationLevel(1);
            for (int j = 1; j < NsTest.MAX_OPERATIONS_PER_CONN; ++j) {
                int n = (int)(Math.random() * 100.0) % 4;
                switch (n) {
                    case 0: {
                        int n2;
                        try {
                            n2 = this.doSelectOperation(NsTest.MAX_LOW_STRESS_ROWS);
                            NsTest.logger.println(this.getThread_id() + " selected " + n2 + " rows");
                        }
                        catch (Exception exception) {
                            NsTest.logger.println("doSelect in thread " + this.getThread_id() + " threw ");
                            this.printException("doSelectOperation() in Tester2", exception);
                        }
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        int n2;
                        for (n2 = 0; n2 < NsTest.MAX_LOW_STRESS_ROWS; ++n2) {
                            this.doIUDOperation();
                        }
                        break;
                    }
                }
                try {
                    this.connex.commit();
                    continue;
                }
                catch (Exception exception) {
                    NsTest.logger.println("FAIL: " + this.getThread_id() + "'s commit() failed:");
                    this.printException("committing Xn in Tester2", exception);
                    return;
                }
            }
            this.closeConnection();
        }
        NsTest.logger.println("Thread " + this.getThread_id() + " is now terminating");
    }
}

