/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TimeHandlingTest
extends BaseJDBCTestCase {
    private static final String[] CURRENT_TIME_FUNCTIONS = new String[]{"CURRENT TIME", "CURRENT_TIME"};
    private static final String[] CURRENT_TIMESTAMP_FUNCTIONS = new String[]{"CURRENT TIMESTAMP", "CURRENT_TIMESTAMP"};
    private static final long SLEEP_TIME = 2000L;
    private Calendar cal;

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(TimeHandlingTest.class);
        baseTestSuite.addTest(TestConfiguration.clientServerSuite(TimeHandlingTest.class));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                statement.execute("CREATE FUNCTION SLEEP() RETURNS INTEGER LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL  EXTERNAL NAME '" + TimeHandlingTest.class.getName().concat(".sleep'"));
                statement.execute("CREATE TABLE TIME_ALL (ID INT, C_T TIME, C_D DATE, C_TS TIMESTAMP)");
                for (n = 0; n < CURRENT_TIME_FUNCTIONS.length; ++n) {
                    statement.execute("ALTER TABLE TIME_ALL ADD COLUMN D_T" + n + " TIME WITH DEFAULT " + CURRENT_TIME_FUNCTIONS[n]);
                }
                for (n = 0; n < CURRENT_TIMESTAMP_FUNCTIONS.length; ++n) {
                    statement.execute("ALTER TABLE TIME_ALL ADD COLUMN D_TS" + n + " TIMESTAMP WITH DEFAULT " + CURRENT_TIMESTAMP_FUNCTIONS[n]);
                }
            }
        };
    }

    public static int sleep() throws InterruptedException {
        Thread.sleep(2000L);
        return 0;
    }

    public TimeHandlingTest(String string) {
        super(string);
    }

    protected void setUp() throws SQLException {
        this.cal = Calendar.getInstance();
        Statement statement = this.createStatement();
        statement.executeUpdate("DELETE FROM TIME_ALL");
        statement.close();
    }

    public void testInsertTime() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Random random = new Random();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO TIME_ALL(ID, C_T) VALUES (?, ?)");
        for (int i = 0; i < 500; ++i) {
            int n = random.nextInt(1000000);
            preparedStatement.setInt(1, n);
            Time time = this.getCodedTime(n);
            switch (n % 71 % 3) {
                case 0: {
                    preparedStatement.setTime(2, time);
                    break;
                }
                case 1: {
                    preparedStatement.setString(2, time.toString());
                    break;
                }
                case 2: {
                    preparedStatement.setString(2, time.toString().replace(':', '.'));
                    break;
                }
                default: {
                    TimeHandlingTest.fail((String)"not reached");
                }
            }
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        this.commit();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT ID, C_T FROM TIME_ALL");
        int n = 0;
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            Time time = this.checkTimeValue(resultSet, 2);
            this.assertTimeEqual(this.getCodedTime(n2), time);
            ++n;
        }
        resultSet.close();
        statement.close();
        this.commit();
        TimeHandlingTest.assertEquals((int)n, (int)500);
    }

    private Time getCodedTime(int n) {
        int n2 = n % 17 % 24;
        int n3 = n % 41 % 60;
        int n4 = n % 67 % 60;
        return this.getTime19700101(n2, n3, n4);
    }

    public void testCurrentTime() throws SQLException, InterruptedException {
        this.currentFunctionTests(92, CURRENT_TIME_FUNCTIONS);
    }

    public void testCurrentTimestamp() throws SQLException, InterruptedException {
        this.currentFunctionTests(93, CURRENT_TIMESTAMP_FUNCTIONS);
    }

    private void currentFunctionTests(int n, String[] stringArray) throws SQLException, InterruptedException {
        Statement statement = this.createStatement();
        for (int i = 0; i < stringArray.length; ++i) {
            this.checkCurrentQuery(n, statement, "VALUES " + stringArray[i], new int[]{1}, 1);
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i + 1;
        }
        String string2 = "VALUES " + string;
        this.checkCurrentQuery(n, statement, string2, nArray, stringArray.length);
        string2 = "VALUES " + string + "," + string + "," + string;
        this.checkCurrentQuery(n, statement, string2, nArray, 3 * stringArray.length);
        String string3 = string.substring(0, string.length() - 1) + ", SLEEP())";
        string2 = "VALUES " + string3 + "," + string3 + "," + string3;
        this.checkCurrentQuery(n, statement, string2, nArray, 3 * stringArray.length);
        String string4 = null;
        String string5 = null;
        switch (n) {
            case 92: {
                string5 = "D_T";
                string4 = "C_T";
                break;
            }
            case 93: {
                string5 = "D_TS";
                string4 = "C_TS";
                break;
            }
            case 91: {
                string5 = "D_D";
                string4 = "C_D";
                break;
            }
            default: {
                TimeHandlingTest.fail((String)("Unexpected JDBC Type " + n));
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append(stringArray[i]);
        }
        String string6 = stringBuffer2.toString();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append(string4);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer3.append(", ");
            stringBuffer3.append(string5);
            stringBuffer3.append(i);
        }
        String string7 = stringBuffer3.toString();
        String string8 = "SELECT " + string7 + " FROM TIME_ALL";
        int[] nArray2 = new int[nArray.length + 1];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i + 1;
        }
        String string9 = "INSERT INTO TIME_ALL(" + string4 + ") VALUES " + string6;
        statement.executeUpdate("DELETE FROM TIME_ALL");
        long l = System.currentTimeMillis();
        statement.executeUpdate(string9);
        long l2 = System.currentTimeMillis();
        ResultSet resultSet = statement.executeQuery(string8);
        resultSet.next();
        this.checkCurrentMultiple(n, l, l2, resultSet, nArray2, stringArray.length * (stringArray.length + 1));
        resultSet.close();
        stringBuffer3 = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer3.append(", ");
            }
            stringBuffer3.append("(SLEEP(), ");
            stringBuffer3.append(stringArray[i]);
            stringBuffer3.append(")");
        }
        String string10 = stringBuffer3.toString();
        string9 = "INSERT INTO TIME_ALL(ID, " + string4 + ")  SELECT * FROM TABLE (VALUES " + string10 + ") AS T";
        statement.executeUpdate("DELETE FROM TIME_ALL");
        l = System.currentTimeMillis();
        statement.executeUpdate(string9);
        l2 = System.currentTimeMillis();
        resultSet = statement.executeQuery(string8);
        resultSet.next();
        this.checkCurrentMultiple(n, l, l2, resultSet, nArray2, stringArray.length * (stringArray.length + 1));
        resultSet.close();
        PreparedStatement preparedStatement = this.prepareStatement(string8 + " WHERE ID = ?");
        Object object = null;
        for (int i = 0; i < stringArray.length; ++i) {
            PreparedStatement preparedStatement2 = this.prepareStatement("INSERT INTO TIME_ALL(ID, " + string4 + ") VALUES (?, " + stringArray[i] + ")");
            statement.executeUpdate("DELETE FROM TIME_ALL");
            for (int j = 1; j <= 3; ++j) {
                preparedStatement2.setInt(1, j);
                preparedStatement.setInt(1, j);
                l = System.currentTimeMillis();
                preparedStatement2.executeUpdate();
                l2 = System.currentTimeMillis();
                resultSet = preparedStatement.executeQuery();
                resultSet.next();
                Object object2 = this.checkCurrentMultiple(n, l, l2, resultSet, nArray2, stringArray.length + 1);
                resultSet.close();
                if (object != null) {
                    TimeHandlingTest.assertFalse((String)"CURRENT value not changed over executions", (boolean)object.equals(object2));
                }
                object = object2;
                Thread.sleep(2000L);
            }
            preparedStatement2.close();
        }
        preparedStatement.close();
        statement.close();
    }

    private void checkCurrentQuery(int n, Statement statement, String string, int[] nArray, int n2) throws SQLException {
        long l = System.currentTimeMillis();
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        long l2 = System.currentTimeMillis();
        this.checkCurrentMultiple(n, l, l2, resultSet, nArray, n2);
        resultSet.close();
    }

    private Object checkCurrentMultiple(int n, long l, long l2, ResultSet resultSet, int[] nArray, int n2) throws SQLException {
        switch (n) {
            case 92: {
                return this.checkCurrentTimeMultiple(l, l2, resultSet, nArray, n2);
            }
            case 93: {
                return this.checkCurrentTimestampMultiple(l, l2, resultSet, nArray, n2);
            }
        }
        TimeHandlingTest.fail((String)("Unexpected type " + n));
        return null;
    }

    private Time checkCurrentTimeMultiple(long l, long l2, ResultSet resultSet, int[] nArray, int n) throws SQLException {
        Time time;
        int n2;
        Time time2 = this.checkCurrentTimeValue(l, l2, resultSet, nArray[0]);
        TimeHandlingTest.assertNotNull((Object)time2);
        int n3 = 1;
        for (n2 = 1; n2 < nArray.length; ++n2) {
            time = this.checkCurrentTimeValue(l, l2, resultSet, nArray[n2]);
            TimeHandlingTest.assertEquals("CURENT TIME changed during execution", time2, time);
            ++n3;
        }
        while (resultSet.next()) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                time = this.checkCurrentTimeValue(l, l2, resultSet, nArray[n2]);
                TimeHandlingTest.assertEquals("CURENT TIME changed during execution", time2, time);
                ++n3;
            }
        }
        TimeHandlingTest.assertEquals((int)n, (int)n3);
        return time2;
    }

    private Timestamp checkCurrentTimestampMultiple(long l, long l2, ResultSet resultSet, int[] nArray, int n) throws SQLException {
        Timestamp timestamp;
        int n2;
        Timestamp timestamp2 = this.checkCurrentTimestampValue(l, l2, resultSet, nArray[0]);
        TimeHandlingTest.assertNotNull((Object)timestamp2);
        int n3 = 1;
        for (n2 = 1; n2 < nArray.length; ++n2) {
            timestamp = this.checkCurrentTimestampValue(l, l2, resultSet, nArray[n2]);
            TimeHandlingTest.assertEquals((String)"CURENT TIMESTAMP changed during execution", (Object)timestamp2, (Object)timestamp);
            ++n3;
        }
        while (resultSet.next()) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                timestamp = this.checkCurrentTimestampValue(l, l2, resultSet, nArray[n2]);
                TimeHandlingTest.assertEquals((String)"CURENT TIMESTAMP changed during execution", (Object)timestamp2, (Object)timestamp);
                ++n3;
            }
        }
        TimeHandlingTest.assertEquals((int)n, (int)n3);
        return timestamp2;
    }

    private Time checkTimeValue(ResultSet resultSet, int n) throws SQLException {
        TimeHandlingTest.assertEquals((int)92, (int)resultSet.getMetaData().getColumnType(n));
        try {
            resultSet.getDate(n);
            TimeHandlingTest.fail((String)"ResultSet.getDate() succeeded on TIME column");
        }
        catch (SQLException sQLException) {
            TimeHandlingTest.assertSQLState("22005", sQLException);
        }
        Time time = resultSet.getTime(n);
        TimeHandlingTest.assertEquals((time == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
        Object object = resultSet.getObject(n);
        TimeHandlingTest.assertEquals((object == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
        if (time == null) {
            TimeHandlingTest.assertNull((Object)object);
            return null;
        }
        TimeHandlingTest.assertTrue((boolean)(object instanceof Time));
        TimeHandlingTest.assertEquals((Object)time, (Object)object);
        this.assertTime1970(time);
        this.cal.clear();
        this.cal.setTime(time);
        TimeHandlingTest.assertEquals((int)0, (int)this.cal.get(14));
        long l = System.currentTimeMillis();
        Timestamp timestamp = resultSet.getTimestamp(n);
        long l2 = System.currentTimeMillis();
        TimeHandlingTest.assertNotNull((Object)timestamp);
        TimeHandlingTest.assertFalse((boolean)resultSet.wasNull());
        if (this.isDateEqual(l, new Timestamp(l2))) {
            this.cal.clear();
            this.cal.setTimeInMillis(l);
            int n2 = this.cal.get(1);
            int n3 = this.cal.get(2);
            int n4 = this.cal.get(5);
            this.cal.clear();
            this.cal.setTime(time);
            this.cal.set(n2, n3, n4);
            Timestamp timestamp2 = new Timestamp(this.cal.getTimeInMillis());
            this.assertTimeEqual(timestamp2, timestamp);
        }
        if (!this.isDateEqual(l, timestamp) && !this.isDateEqual(l2, timestamp)) {
            TimeHandlingTest.fail((String)("TIME to java.sql.Timestamp does not contain current date " + String.valueOf(timestamp)));
        }
        String string = resultSet.getString(n);
        TimeHandlingTest.assertNotNull((Object)string);
        TimeHandlingTest.assertFalse((boolean)resultSet.wasNull());
        TimeHandlingTest.assertEquals("ResultSet String converted to java.sql.Time mismatch", time, this.getTime19700101(string, this.cal));
        return time;
    }

    private Timestamp checkTimestampValue(ResultSet resultSet, int n) throws SQLException {
        TimeHandlingTest.assertEquals((int)93, (int)resultSet.getMetaData().getColumnType(n));
        Timestamp timestamp = resultSet.getTimestamp(n);
        TimeHandlingTest.assertEquals((timestamp == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
        Object object = resultSet.getObject(n);
        TimeHandlingTest.assertEquals((object == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
        if (timestamp == null) {
            TimeHandlingTest.assertNull((Object)object);
            return null;
        }
        TimeHandlingTest.assertTrue((boolean)(object instanceof Timestamp));
        TimeHandlingTest.assertEquals((Object)timestamp, (Object)object);
        Time time = resultSet.getTime(n);
        TimeHandlingTest.assertNotNull((Object)time);
        TimeHandlingTest.assertFalse((boolean)resultSet.wasNull());
        this.assertTime1970(time);
        this.assertTimeEqual(time, timestamp);
        String string = resultSet.getString(n);
        TimeHandlingTest.assertNotNull((Object)string);
        TimeHandlingTest.assertFalse((boolean)resultSet.wasNull());
        TimeHandlingTest.assertEquals((String)"ResultSet String converted to java.sql.Timestamp mismatch", (Object)timestamp, (Object)Timestamp.valueOf(string));
        return timestamp;
    }

    private Time checkCurrentTimeValue(long l, long l2, ResultSet resultSet, int n) throws SQLException {
        Time time;
        Time time2 = this.checkTimeValue(resultSet, n);
        Time time3 = this.getTime19700101(l, this.cal);
        if (time3.after(time = this.getTime19700101(l2, this.cal))) {
            TimeHandlingTest.assertTrue((String)"CURRENT TIME outside of range when test crossing midnight", (time2.equals(time3) || time2.after(time3) || time2.equals(time) || time2.before(time) ? 1 : 0) != 0);
        } else {
            TimeHandlingTest.assertFalse((String)"CURRENT TIME before start of statement", (boolean)time2.before(time3));
            TimeHandlingTest.assertFalse((String)"CURRENT TIME after end of statement", (boolean)time2.after(time));
        }
        return time2;
    }

    private Timestamp checkCurrentTimestampValue(long l, long l2, ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = this.checkTimestampValue(resultSet, n);
        Timestamp timestamp2 = new Timestamp(l);
        Timestamp timestamp3 = new Timestamp(l2);
        if (timestamp2.after(timestamp3)) {
            TimeHandlingTest.assertTrue((String)"CURRENT TIME outside of range when test crossing midnight", (timestamp.equals(timestamp2) || timestamp.after(timestamp2) || timestamp.equals(timestamp3) || timestamp.before(timestamp3) ? 1 : 0) != 0);
        } else {
            TimeHandlingTest.assertFalse((String)"CURRENT TIME before start of statement", (boolean)timestamp.before(timestamp2));
            TimeHandlingTest.assertFalse((String)"CURRENT TIME after end of statement", (boolean)timestamp.after(timestamp3));
        }
        return timestamp;
    }

    private Time getTime19700101(int n, int n2, int n3) {
        this.cal.clear();
        this.cal.set(1970, 0, 1, n, n2, n3);
        this.cal.set(14, 0);
        Time time = new Time(this.cal.getTimeInMillis());
        this.assertTime1970(time);
        return time;
    }

    private Time getTime19700101(long l, Calendar calendar) {
        calendar.clear();
        calendar.setTimeInMillis(l);
        calendar.set(1970, 0, 1);
        calendar.set(14, 0);
        Time time = new Time(calendar.getTimeInMillis());
        this.assertTime1970(time);
        return time;
    }

    private Time getTime19700101(String string, Calendar calendar) {
        return this.getTime19700101(Time.valueOf(string).getTime(), calendar);
    }

    private void assertTime1970(Time time) {
        this.cal.clear();
        this.cal.setTime(time);
        TimeHandlingTest.assertEquals((int)1970, (int)this.cal.get(1));
        TimeHandlingTest.assertEquals((int)0, (int)this.cal.get(2));
        TimeHandlingTest.assertEquals((int)1, (int)this.cal.get(5));
    }

    private void assertTimeEqual(Date date, Date date2) {
        this.cal.clear();
        this.cal.setTime(date);
        int n = this.cal.get(11);
        int n2 = this.cal.get(12);
        int n3 = this.cal.get(13);
        int n4 = this.cal.get(14);
        this.cal.clear();
        this.cal.setTime(date2);
        TimeHandlingTest.assertEquals((int)n, (int)this.cal.get(11));
        TimeHandlingTest.assertEquals((int)n2, (int)this.cal.get(12));
        TimeHandlingTest.assertEquals((int)n3, (int)this.cal.get(13));
        TimeHandlingTest.assertEquals((int)n4, (int)this.cal.get(14));
    }

    private boolean isDateEqual(long l, Timestamp timestamp) {
        this.cal.clear();
        this.cal.setTimeInMillis(l);
        int n = this.cal.get(5);
        int n2 = this.cal.get(2);
        int n3 = this.cal.get(1);
        this.cal.clear();
        this.cal.setTime(timestamp);
        return n == this.cal.get(5) && n2 == this.cal.get(2) && n3 == this.cal.get(1);
    }
}

