/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VetJigsawTest
extends BaseJDBCTestCase {
    private static final String[] JAR_FILES = new String[]{"derby.jar", "derbyclient.jar", "derbynet.jar", "derbyoptionaltools.jar", "derbyrun.jar", "derbyshared.jar", "derbytools.jar", "derbyTesting.jar"};

    public VetJigsawTest(String string) {
        super(string);
    }

    public static Test suite() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup;
        BaseTestSuite baseTestSuite = new BaseTestSuite(VetJigsawTest.class, "VetJigsawTest");
        CleanDatabaseTestSetup cleanDatabaseTestSetup2 = cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        return cleanDatabaseTestSetup2;
    }

    public void test_jarContents() throws Exception {
        URL uRL = TestConfiguration.getURL("org.apache.derby.impl.jdbc.EmbedConnection");
        String string = uRL.toURI().getPath();
        String string2 = string.substring(0, string.indexOf("derby.jar"));
        String string3 = null;
        try (Connection connection = this.getConnection();){
            this.loadJarFileContents(connection, string2);
            string3 = this.vetContents();
        }
        if (string3 != null && string3.length() != 0) {
            VetJigsawTest.fail((String)("Jar files overlap!\n" + string3));
        }
    }

    private void loadJarFileContents(Connection connection, String string) throws Exception {
        this.goodStatement(connection, "create function zipFile(zipFileName varchar( 32672 ))\nreturns table\n(\n      name   varchar( 100 ),\n      directory varchar( 32672 ),\n      comment varchar( 100 ),\n      crc varchar(100),\n      size bigint,\n      modification_time timestamp\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ZipFileTableFunction.zipFile'\n");
        this.goodStatement(connection, "create table zipPackages\n(\n  packageName varchar(32672),\n  zipFileName varchar(32672),\n  primary key (packageName, zipFileName)\n)\n");
        this.goodStatement(connection, "create table zipClasses\n(\n  packageName varchar(32672),\n  zipFileName varchar(32672),\n  className varchar(32672),\n  primary key (packageName, zipFileName, className)\n)\n");
        for (String string2 : JAR_FILES) {
            this.loadJarFile(connection, string, string2);
        }
    }

    private void loadJarFile(Connection connection, String string, String string2) throws Exception {
        String string3 = string + string2;
        this.goodStatement(connection, "insert into zipPackages\n  select distinct directory, '" + string3 + "'\n  from table(zipfile('" + string3 + "')) t\n");
        this.goodStatement(connection, "insert into zipClasses\n  select directory, '" + string3 + "', name\n  from table(zipFile('" + string3 + "')) t\n  where name like '%.class' and name <> 'module-info.class'");
    }

    private String vetContents() throws Exception {
        String string = "select packageName, count(packageName) instanceCount\nfrom zipPackages\nwhere packageName not like 'META-INF%'\ngroup by packageName\nhaving count(packageName) > 1\n";
        StringBuilder stringBuilder = new StringBuilder();
        try (PreparedStatement preparedStatement = this.prepareStatement(string);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                this.examinePackage(stringBuilder, string2);
            }
        }
        return stringBuilder.toString();
    }

    private void examinePackage(StringBuilder stringBuilder, String string) throws Exception {
        String string2 = "select zipFileName, className\nfrom zipClasses\nwhere packageName = '" + string + "'\norder by zipFileName, className\n";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try (PreparedStatement preparedStatement = this.prepareStatement(string2);){
            Object var7_7 = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    if (var7_7 != null && !string3.equals(var7_7)) {
                        ++n;
                    }
                    stringBuffer.append("    ").append(string3).append("\t").append(string4).append("\n");
                }
            }
        }
        if (n > 1) {
            stringBuilder.append(string + " straddles more than one jar file:\n").append(stringBuffer.toString()).append("\n");
        }
    }
}

