/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.render.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.render.afp.modca.IMImageObject;
import org.apache.fop.render.afp.modca.ImageCellPosition;
import org.apache.fop.render.afp.modca.ImageInputDescriptor;
import org.apache.fop.render.afp.modca.ImageObject;
import org.apache.fop.render.afp.modca.ImageOutputControl;
import org.apache.fop.render.afp.modca.ImageRasterData;
import org.apache.fop.render.afp.modca.ImageRasterPattern;
import org.apache.fop.render.afp.modca.IncludePageSegment;
import org.apache.fop.render.afp.modca.PresentationTextObject;
import org.apache.fop.render.afp.modca.TagLogicalElement;
import org.apache.fop.render.afp.tools.StringUtils;

public abstract class AbstractPageObject
extends AbstractNamedAFPObject {
    protected ActiveEnvironmentGroup _activeEnvironmentGroup = null;
    private PresentationTextObject _presentationTextObject = null;
    protected List _objects = new ArrayList();
    protected ArrayList _tagLogicalElements = new ArrayList();
    protected ArrayList _segments = new ArrayList();
    private int _width;
    private int _height;
    private int _rotation = 0;
    private boolean _complete = false;

    public AbstractPageObject(String name, int width, int height, int rotation) {
        super(name);
        this._name = name;
        this._rotation = rotation;
        this._width = width;
        this._height = height;
        this._activeEnvironmentGroup = new ActiveEnvironmentGroup(this._width, this._height);
        if (this._rotation != 0) {
            switch (this._rotation) {
                case 90: {
                    this._activeEnvironmentGroup.setPosition(this._width, 0, this._rotation);
                    break;
                }
                case 180: {
                    this._activeEnvironmentGroup.setPosition(this._width, this._height, this._rotation);
                    break;
                }
                case 270: {
                    this._activeEnvironmentGroup.setPosition(0, this._height, this._rotation);
                }
            }
        }
        this._presentationTextObject = new PresentationTextObject();
        this._objects.add(this._presentationTextObject);
    }

    public void createFont(byte fontReference, AFPFont font, int size) {
        this._activeEnvironmentGroup.createFont(fontReference, font, size, 0);
    }

    public void createLine(int x1, int y1, int x2, int y2, int thickness, int rotation, Color col) {
        if (this._presentationTextObject == null) {
            this._presentationTextObject = new PresentationTextObject();
            this._objects.add(this._presentationTextObject);
        }
        this._presentationTextObject.createLineData(x1, y1, x2, y2, thickness, rotation, col);
    }

    public void createText(int fontNumber, int x, int y, int rotation, Color col, int vsci, int ica, byte[] data) {
        if (this._presentationTextObject == null) {
            this._presentationTextObject = new PresentationTextObject();
            this._objects.add(this._presentationTextObject);
        }
        this._presentationTextObject.createTextData(fontNumber, x, y, rotation, col, vsci, ica, data);
    }

    public void endPage() {
        if (this._presentationTextObject != null) {
            this._presentationTextObject.endControlSequence();
        }
        this._complete = true;
    }

    public void createShading(int x, int y, int w, int h, int red, int green, int blue) {
        int xCoord = 0;
        int yCoord = 0;
        int width = 0;
        int height = 0;
        switch (this._rotation) {
            case 90: {
                xCoord = this._width - y - h;
                yCoord = x;
                width = h;
                height = w;
                break;
            }
            case 180: {
                xCoord = this._width - x - w;
                yCoord = this._height - y - h;
                width = w;
                height = h;
                break;
            }
            case 270: {
                xCoord = y;
                yCoord = this._height - x - w;
                width = h;
                height = w;
                break;
            }
            default: {
                xCoord = x;
                yCoord = y;
                width = w;
                height = h;
            }
        }
        float shade = (float)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
        int greyscale = Math.round(shade / 255.0f * 16.0f);
        String imageName = "IMG" + StringUtils.lpad(String.valueOf(this._objects.size() + 1), '0', 5);
        IMImageObject io = new IMImageObject(imageName);
        ImageOutputControl ioc = new ImageOutputControl(0, 0);
        ImageInputDescriptor iid = new ImageInputDescriptor();
        ImageCellPosition icp = new ImageCellPosition(xCoord, yCoord);
        icp.setXFillSize(width);
        icp.setYFillSize(height);
        icp.setXSize(64);
        icp.setYSize(8);
        ImageRasterData ird = new ImageRasterData(ImageRasterPattern.getRasterData(greyscale));
        io.setImageOutputControl(ioc);
        io.setImageInputDescriptor(iid);
        io.setImageCellPosition(icp);
        io.setImageRasterData(ird);
        this._objects.add(io);
    }

    public ImageObject getImageObject() {
        if (this._presentationTextObject != null) {
            this._presentationTextObject.endControlSequence();
        }
        this._presentationTextObject = null;
        String imageName = "IMG" + StringUtils.lpad(String.valueOf(this._objects.size() + 1), '0', 5);
        ImageObject io = new ImageObject(imageName);
        this._objects.add(io);
        return io;
    }

    public void createTagLogicalElement(String name, String value) {
        TagLogicalElement tle = new TagLogicalElement(name, value);
        this._tagLogicalElements.add(tle);
    }

    public void createIncludePageSegment(String name, int xCoor, int yCoor) {
        IncludePageSegment ips = new IncludePageSegment(name, xCoor, yCoor);
        this._segments.add(ips);
    }

    public ActiveEnvironmentGroup getActiveEnvironmentGroup() {
        return this._activeEnvironmentGroup;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public int getHeight() {
        return this._height;
    }

    public int getWidth() {
        return this._width;
    }

    public int getRotation() {
        return this._rotation;
    }
}

