/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om;

import java.io.Serializable;
import java.util.Objects;

public abstract class ObjectKey<T>
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = 1L;
    private T key = null;

    public int hashCode() {
        if (this.key == null) {
            return super.hashCode();
        }
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ObjectKey objectKey = (ObjectKey)obj;
        if (this.key == null) {
            return false;
        }
        return this.key.equals(objectKey.getValue());
    }

    public T getValue() {
        return this.key;
    }

    public abstract int getJdbcType();

    public void appendTo(StringBuilder sb) {
        sb.append(this.toString());
    }

    @Override
    public int compareTo(Object obj) {
        return this.toString().compareTo(obj.toString());
    }

    public void setValue(T key) {
        this.key = key;
    }

    public <O extends ObjectKey<T>> void setValue(O key) {
        this.key = key != null ? key.getValue() : null;
    }

    public String toString() {
        return Objects.toString(this.key, "");
    }
}

