/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template.groovy;

import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.template.groovy.GroovyOutlet;
import org.apache.torque.generator.variable.Variable;

public class TorqueGenGroovy {
    private final ControllerState controllerState;
    private final GroovyOutlet outlet;
    private static int counter = 1;

    public TorqueGenGroovy(GroovyOutlet outlet, ControllerState controllerState) {
        if (controllerState == null) {
            throw new NullPointerException("controllerState may not be null");
        }
        if (outlet == null) {
            throw new NullPointerException("outlet may not be null");
        }
        this.controllerState = controllerState;
        this.outlet = outlet;
    }

    public String mergepoint(String mergepointName) throws GeneratorException {
        return this.outlet.mergepoint(mergepointName, this.controllerState);
    }

    public ControllerState getControllerState() {
        return this.controllerState;
    }

    public Object getModel() {
        return this.controllerState.getModel();
    }

    public Object option(String key) {
        Object result = this.controllerState.getOption(key);
        return result;
    }

    public Object getOption(String key) {
        Object result = this.controllerState.getOption(key);
        return result;
    }

    public boolean booleanOption(String key) {
        boolean result = this.controllerState.getBooleanOption(key);
        return result;
    }

    public int intOption(String key) {
        Object optionValue = this.controllerState.getOption(key);
        if (optionValue == null) {
            return 0;
        }
        String optionString = optionValue.toString();
        if (StringUtils.isBlank((CharSequence)optionString)) {
            return 0;
        }
        return Integer.parseInt(optionString);
    }

    public Object getVariable(String key) {
        return this.outlet.getVariable(key, this.controllerState);
    }

    public void setVariable(String key, Object value) {
        this.outlet.setVariable(key, value, this.controllerState);
    }

    public void setVariable(String key, Object value, String scope) {
        Variable.Scope scopeValue = Variable.Scope.valueOf(scope);
        this.outlet.setVariable(key, value, scopeValue, this.controllerState);
    }

    public File getSourceFile() {
        return this.controllerState.getSourceFile();
    }

    public Date now() {
        return new Date();
    }

    public static synchronized int getCounter() {
        return counter++;
    }

    public static synchronized void resetCounter() {
        counter = 1;
    }
}

