/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.util.Nonbinding;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.deltaspike.core.util.ExceptionUtils;

@Vetoed
public abstract class ReflectionUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private ReflectionUtils() {
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(fields, c.getDeclaredFields());
        }
        return fields;
    }

    public static Field tryToFindDeclaredField(Class<?> clazz, String name) {
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(methods, c.getDeclaredMethods());
        }
        return methods;
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Details: Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append(i > 0 ? ", " : "").append(args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static <T> T invokeMethod(Object instance, Method method, Class<T> expectedReturnType, boolean setAccessible, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.throwAsRuntimeException(e.getCause());
            return null;
        }
        catch (Exception e) {
            String customMessage = ReflectionUtils.createCustomMessage(e, method, instance, args);
            ExceptionUtils.changeAndThrowException(e, customMessage);
            return null;
        }
    }

    private static String createCustomMessage(Exception e, Method method, Object targetObject, Object ... arguments) {
        return e.getMessage() + ReflectionUtils.buildInvokeMethodErrorMessage(method, targetObject, arguments);
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null isn't supported");
        }
        return clazz.getTypeParameters();
    }

    public static Type[] getActualTypeArguments(Type type) {
        if (type instanceof Class) {
            return ReflectionUtils.getActualTypeArguments((Class)type);
        }
        throw new IllegalArgumentException((type != null ? type.getClass().getName() : "null") + " isn't supported");
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParameterizedTypeWithWildcard(Class<?> type) {
        if (ReflectionUtils.isParameterizedType(type)) {
            return ReflectionUtils.containsWildcards(type.getTypeParameters());
        }
        return false;
    }

    private static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Type type) {
        Class rawType = ReflectionUtils.getRawType(type);
        return rawType != null && rawType.isPrimitive();
    }

    public static int calculateHashCodeOfAnnotation(Annotation annotation, boolean skipNonbindingMembers) {
        Method[] members;
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        int hashCode = ReflectionUtils.calculateHashCodeOfType(annotationClass);
        for (Method member : members = annotationClass.getDeclaredMethods()) {
            Class<?> type;
            if (skipNonbindingMembers && member.isAnnotationPresent(Nonbinding.class)) continue;
            Object object = ReflectionUtils.invokeMethod(annotation, member, Object.class, true, EMPTY_OBJECT_ARRAY);
            int value = object.getClass().isArray() ? ((type = object.getClass().getComponentType()).isPrimitive() ? (Long.TYPE == type ? Arrays.hashCode((long[])object) : (Integer.TYPE == type ? Arrays.hashCode((int[])object) : (Short.TYPE == type ? Arrays.hashCode((short[])object) : (Double.TYPE == type ? Arrays.hashCode((double[])object) : (Float.TYPE == type ? Arrays.hashCode((float[])object) : (Boolean.TYPE == type ? Arrays.hashCode((boolean[])object) : (Byte.TYPE == type ? Arrays.hashCode((byte[])object) : (Character.TYPE == type ? Arrays.hashCode((char[])object) : 0)))))))) : Arrays.hashCode((Object[])object)) : object.hashCode();
            hashCode = 29 * hashCode + value;
            hashCode = 29 * hashCode + member.getName().hashCode();
        }
        return hashCode;
    }

    public static int calculateHashCodeOfType(Type type) {
        int typeHash = type.hashCode();
        if (typeHash == 0 && type instanceof Class) {
            return ((Class)type).getName().hashCode();
        }
        return typeHash;
    }

    public static boolean hasSameSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && a.getReturnType().equals(b.getReturnType()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }
}

