/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.RocksDBOptions;
import org.apache.flink.table.store.connector.lookup.RocksDBSetState;
import org.apache.flink.table.store.connector.lookup.RocksDBValueState;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBStateFactory
implements Closeable {
    private RocksDB db;
    private final ColumnFamilyOptions columnFamilyOptions;

    public RocksDBStateFactory(String path, Configuration conf) throws IOException {
        DBOptions dbOptions = RocksDBOptions.createDBOptions(new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0).setCreateIfMissing(true), conf);
        this.columnFamilyOptions = RocksDBOptions.createColumnOptions(new ColumnFamilyOptions(), conf);
        try {
            this.db = RocksDB.open((Options)new Options(dbOptions, this.columnFamilyOptions), (String)path);
        }
        catch (RocksDBException e) {
            throw new IOException("Error while opening RocksDB instance.", e);
        }
    }

    public RocksDBValueState valueState(String name, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBValueState(this.db, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    public RocksDBSetState setState(String name, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBSetState(this.db, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    private ColumnFamilyHandle createColumnFamily(String name) throws IOException {
        try {
            return this.db.createColumnFamily(new ColumnFamilyDescriptor(name.getBytes(StandardCharsets.UTF_8), this.columnFamilyOptions));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }
}

