/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;

public class SerializationUtils {
    public static void serializeBytes(DataOutputView out, byte[] binary) throws IOException {
        out.writeInt(binary.length);
        out.write(binary);
    }

    public static byte[] deserializedBytes(DataInputView in) throws IOException {
        int len = in.readInt();
        byte[] buf = new byte[len];
        int off = 0;
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new EOFException();
            }
            toRead -= ret;
            off += ret;
        }
        return buf;
    }

    public static VarBinaryType newBytesType(boolean isNullable) {
        return new VarBinaryType(isNullable, Integer.MAX_VALUE);
    }

    public static VarCharType newStringType(boolean isNullable) {
        return new VarCharType(isNullable, Integer.MAX_VALUE);
    }

    public static byte[] serializeBinaryRow(BinaryRowData row) {
        byte[] bytes = BinarySegmentUtils.copyToBytes((MemorySegment[])row.getSegments(), (int)row.getOffset(), (int)row.getSizeInBytes());
        ByteBuffer buffer = ByteBuffer.allocate(4 + bytes.length);
        buffer.putInt(row.getArity()).put(bytes);
        return buffer.array();
    }

    public static BinaryRowData deserializeBinaryRow(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int arity = buffer.getInt();
        BinaryRowData row = new BinaryRowData(arity);
        row.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 4, bytes.length - 4);
        return row;
    }

    public static void serializeBinaryRow(BinaryRowData row, DataOutputView out) throws IOException {
        out.writeInt(4 + row.getSizeInBytes());
        out.writeInt(row.getArity());
        BinarySegmentUtils.copyToView((MemorySegment[])row.getSegments(), (int)row.getOffset(), (int)row.getSizeInBytes(), (DataOutputView)out);
    }

    public static BinaryRowData deserializeBinaryRow(DataInputView input) throws IOException {
        return SerializationUtils.deserializeBinaryRow(SerializationUtils.deserializedBytes(input));
    }
}

