/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.util.ArrayList;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.store.file.utils.ObjectSerializer;
import org.apache.flink.table.store.file.utils.OffsetRowData;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public abstract class VersionedObjectSerializer<T>
extends ObjectSerializer<T> {
    private static final long serialVersionUID = 1L;

    public VersionedObjectSerializer(RowType rowType) {
        super(VersionedObjectSerializer.versionType(rowType));
    }

    public static RowType versionType(RowType rowType) {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField("_VERSION", (LogicalType)new IntType(false)));
        fields.addAll(rowType.getFields());
        return new RowType(fields);
    }

    public abstract int getVersion();

    public abstract RowData convertTo(T var1);

    public abstract T convertFrom(int var1, RowData var2);

    @Override
    public final RowData toRow(T record) {
        return new JoinedRowData().replace((RowData)GenericRowData.of((Object[])new Object[]{this.getVersion()}), this.convertTo(record));
    }

    @Override
    public final T fromRow(RowData row) {
        return this.convertFrom(row.getInt(0), new OffsetRowData(row.getArity() - 1, 1).replace(row));
    }
}

