/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.orc;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.table.data.ColumnarRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.filesystem.ColumnarRowIterator;
import org.apache.flink.table.filesystem.PartitionFieldExtractor;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.AbstractOrcFileInputFormat;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.AbstractOrcColumnVector;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.ColumnBatchFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.OrcVectorizedBatchWrapper;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;

public class OrcColumnarRowFileInputFormat<BatchT, SplitT extends FileSourceSplit>
extends AbstractOrcFileInputFormat<RowData, BatchT, SplitT> {
    private static final long serialVersionUID = 1L;
    private final ColumnBatchFactory<BatchT, SplitT> batchFactory;
    private final RowType projectedOutputType;

    public OrcColumnarRowFileInputFormat(OrcShim<BatchT> shim, Configuration hadoopConfig, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, ColumnBatchFactory<BatchT, SplitT> batchFactory, RowType projectedOutputType) {
        super(shim, hadoopConfig, schema, selectedFields, conjunctPredicates, batchSize);
        this.batchFactory = batchFactory;
        this.projectedOutputType = projectedOutputType;
    }

    @Override
    public AbstractOrcFileInputFormat.OrcReaderBatch<RowData, BatchT> createReaderBatch(SplitT split, OrcVectorizedBatchWrapper<BatchT> orcBatch, Pool.Recycler<AbstractOrcFileInputFormat.OrcReaderBatch<RowData, BatchT>> recycler, int batchSize) {
        VectorizedColumnBatch flinkColumnBatch = this.batchFactory.create(split, orcBatch.getBatch());
        return new VectorizedColumnReaderBatch<BatchT>(orcBatch, flinkColumnBatch, recycler);
    }

    @Override
    public TypeInformation<RowData> getProducedType() {
        return InternalTypeInfo.of((RowType)this.projectedOutputType);
    }

    public static <SplitT extends FileSourceSplit> OrcColumnarRowFileInputFormat<VectorizedRowBatch, SplitT> createPartitionedFormat(OrcShim<VectorizedRowBatch> shim, Configuration hadoopConfig, RowType tableType, List<String> partitionKeys, PartitionFieldExtractor<SplitT> extractor, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize) {
        String[] tableFieldNames = tableType.getFieldNames().toArray(new String[0]);
        LogicalType[] tableFieldTypes = tableType.getChildren().toArray(new LogicalType[0]);
        List<String> orcFieldNames = OrcSplitReaderUtil.getNonPartNames(tableFieldNames, partitionKeys);
        int[] orcSelectedFields = OrcSplitReaderUtil.getSelectedOrcFields(tableFieldNames, selectedFields, orcFieldNames);
        ColumnBatchFactory<VectorizedRowBatch, FileSourceSplit> batchGenerator = (split, rowBatch) -> {
            ColumnVector[] vectors = new ColumnVector[selectedFields.length];
            for (int i = 0; i < vectors.length; ++i) {
                String name = tableFieldNames[selectedFields[i]];
                LogicalType type = tableFieldTypes[selectedFields[i]];
                vectors[i] = partitionKeys.contains(name) ? AbstractOrcColumnVector.createFlinkVectorFromConstant(type, extractor.extract(split, name, type), batchSize) : AbstractOrcColumnVector.createFlinkVector(rowBatch.cols[orcFieldNames.indexOf(name)], type);
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new OrcColumnarRowFileInputFormat<VectorizedRowBatch, FileSourceSplit>(shim, hadoopConfig, OrcSplitReaderUtil.convertToOrcTypeWithPart(tableFieldNames, tableFieldTypes, partitionKeys), orcSelectedFields, conjunctPredicates, batchSize, batchGenerator, new RowType(Arrays.stream(selectedFields).mapToObj(i -> (RowType.RowField)tableType.getFields().get(i)).collect(Collectors.toList())));
    }

    private static final class VectorizedColumnReaderBatch<BatchT>
    extends AbstractOrcFileInputFormat.OrcReaderBatch<RowData, BatchT> {
        private final VectorizedColumnBatch flinkColumnBatch;
        private final ColumnarRowIterator result;

        VectorizedColumnReaderBatch(OrcVectorizedBatchWrapper<BatchT> orcBatch, VectorizedColumnBatch flinkColumnBatch, Pool.Recycler<AbstractOrcFileInputFormat.OrcReaderBatch<RowData, BatchT>> recycler) {
            super(orcBatch, recycler);
            this.flinkColumnBatch = flinkColumnBatch;
            this.result = new ColumnarRowIterator(new ColumnarRowData(flinkColumnBatch), this::recycle);
        }

        @Override
        public BulkFormat.RecordIterator<RowData> convertAndGetIterator(OrcVectorizedBatchWrapper<BatchT> orcBatch, long startingOffset) {
            int batchSize = orcBatch.size();
            this.flinkColumnBatch.setNumRows(batchSize);
            this.result.set(batchSize, startingOffset, 0L);
            return this.result;
        }
    }
}

