/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;

public class ListColumnVector
extends MultiValuedColumnVector {
    public ColumnVector child;

    public ListColumnVector() {
        this(1024, null);
    }

    public ListColumnVector(int len, ColumnVector child) {
        super(ColumnVector.Type.LIST, len);
        this.child = child;
    }

    @Override
    protected void childFlatten(boolean useSelected, int[] selected, int size) {
        this.child.flatten(useSelected, selected, size);
    }

    @Override
    public void setElement(int outputElementNum, int inputElementNum, ColumnVector inputColVector) {
        if (this.isRepeating && outputElementNum != 0) {
            throw new RuntimeException("Output column number expected to be 0 when isRepeating");
        }
        if (inputColVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!this.noNulls && this.isNull[outputElementNum]) {
            return;
        }
        if (inputColVector.noNulls || !inputColVector.isNull[inputElementNum]) {
            ListColumnVector input = (ListColumnVector)inputColVector;
            int offset = this.childCount;
            int length = (int)input.lengths[inputElementNum];
            int inputOffset = (int)input.offsets[inputElementNum];
            this.offsets[outputElementNum] = offset;
            this.childCount += length;
            this.lengths[outputElementNum] = length;
            this.child.ensureSize(this.childCount, true);
            for (int i = 0; i < length; ++i) {
                int outputIndex = i + offset;
                this.child.isNull[outputIndex] = false;
                this.child.setElement(outputIndex, inputOffset + i, input.child);
            }
        } else {
            this.isNull[outputElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('[');
            boolean isFirst = true;
            for (long i = this.offsets[row]; i < this.offsets[row] + this.lengths[row]; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                this.child.stringifyValue(buffer, (int)i);
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void init() {
        super.init();
        this.child.init();
    }

    @Override
    public void reset() {
        super.reset();
        this.child.reset();
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        if (!this.isRepeating || this.noNulls || !this.isNull[0]) {
            this.child.unFlatten();
        }
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector outputColVector) {
        throw new RuntimeException("Not supported");
    }
}

