/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.flink.table.store.shaded.org.apache.kafka.clients.admin.SupportedVersionRange;

public class FeatureMetadata {
    private final Map<String, FinalizedVersionRange> finalizedFeatures;
    private final Optional<Long> finalizedFeaturesEpoch;
    private final Map<String, SupportedVersionRange> supportedFeatures;

    FeatureMetadata(Map<String, FinalizedVersionRange> finalizedFeatures, Optional<Long> finalizedFeaturesEpoch, Map<String, SupportedVersionRange> supportedFeatures) {
        this.finalizedFeatures = new HashMap<String, FinalizedVersionRange>(finalizedFeatures);
        this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
        this.supportedFeatures = new HashMap<String, SupportedVersionRange>(supportedFeatures);
    }

    public Map<String, FinalizedVersionRange> finalizedFeatures() {
        return new HashMap<String, FinalizedVersionRange>(this.finalizedFeatures);
    }

    public Optional<Long> finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }

    public Map<String, SupportedVersionRange> supportedFeatures() {
        return new HashMap<String, SupportedVersionRange>(this.supportedFeatures);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeatureMetadata)) {
            return false;
        }
        FeatureMetadata that = (FeatureMetadata)other;
        return Objects.equals(this.finalizedFeatures, that.finalizedFeatures) && Objects.equals(this.finalizedFeaturesEpoch, that.finalizedFeaturesEpoch) && Objects.equals(this.supportedFeatures, that.supportedFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.finalizedFeatures, this.finalizedFeaturesEpoch, this.supportedFeatures);
    }

    private static <ValueType> String mapToString(Map<String, ValueType> featureVersionsMap) {
        return String.format("{%s}", featureVersionsMap.entrySet().stream().map(entry -> String.format("(%s -> %s)", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")));
    }

    public String toString() {
        return String.format("FeatureMetadata{finalizedFeatures:%s, finalizedFeaturesEpoch:%s, supportedFeatures:%s}", FeatureMetadata.mapToString(this.finalizedFeatures), this.finalizedFeaturesEpoch.map(Object::toString).orElse("<none>"), FeatureMetadata.mapToString(this.supportedFeatures));
    }
}

