/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.streaming.api.TimerService;

public interface CleanupState {
    default public void registerProcessingCleanupTimer(ValueState<Long> cleanupTimeState, long currentTime, long minRetentionTime, long maxRetentionTime, TimerService timerService) throws Exception {
        Long curCleanupTime = cleanupTimeState.value();
        if (curCleanupTime == null || currentTime + minRetentionTime > curCleanupTime) {
            long cleanupTime = currentTime + maxRetentionTime;
            timerService.registerProcessingTimeTimer(cleanupTime);
            if (curCleanupTime != null) {
                timerService.deleteProcessingTimeTimer(curCleanupTime);
            }
            cleanupTimeState.update(cleanupTime);
        }
    }
}

