/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.Objects;
import org.apache.flink.table.store.file.schema.DataType;
import org.apache.flink.table.types.logical.MapType;

public class MapDataType
extends DataType {
    private static final long serialVersionUID = 1L;
    private final DataType keyType;
    private final DataType valueType;

    public MapDataType(boolean isNullable, DataType keyType, DataType valueType) {
        super(new MapType(isNullable, keyType.logicalType, valueType.logicalType));
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public DataType keyType() {
        return this.keyType;
    }

    public DataType valueType() {
        return this.valueType;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new MapDataType(isNullable, this.keyType, this.valueType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapDataType that = (MapDataType)o;
        return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }
}

