/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class CompositeTypeSerializerConfigSnapshot<T>
extends TypeSerializerConfigSnapshot<T> {
    private List<Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> nestedSerializersAndConfigs;

    public CompositeTypeSerializerConfigSnapshot() {
    }

    public CompositeTypeSerializerConfigSnapshot(TypeSerializer<?> ... nestedSerializers) {
        Preconditions.checkNotNull(nestedSerializers);
        this.nestedSerializersAndConfigs = new ArrayList(nestedSerializers.length);
        for (TypeSerializer<?> nestedSerializer : nestedSerializers) {
            TypeSerializerSnapshot<?> configSnapshot = nestedSerializer.snapshotConfiguration();
            this.nestedSerializersAndConfigs.add(new Tuple2(nestedSerializer.duplicate(), Preconditions.checkNotNull(configSnapshot)));
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience(out, this.nestedSerializersAndConfigs);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.nestedSerializersAndConfigs = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience(in, this.getUserCodeClassLoader());
    }

    public List<Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> getNestedSerializersAndConfigs() {
        return this.nestedSerializersAndConfigs;
    }

    public Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>> getSingleNestedSerializerAndConfig() {
        return this.nestedSerializersAndConfigs.get(0);
    }

    public TypeSerializerSnapshot<?>[] getNestedSerializerSnapshots() {
        return (TypeSerializerSnapshot[])this.nestedSerializersAndConfigs.stream().map(nestedSerializerAndConfig -> (TypeSerializerSnapshot)nestedSerializerAndConfig.f1).toArray(TypeSerializerSnapshot[]::new);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && this.nestedSerializersAndConfigs.equals(((CompositeTypeSerializerConfigSnapshot)obj).getNestedSerializersAndConfigs());
    }

    public int hashCode() {
        return this.nestedSerializersAndConfigs.hashCode();
    }
}

