/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.RetryStrategy;

public class RpcGatewayRetriever<F extends Serializable, T extends FencedRpcGateway<F>>
extends LeaderGatewayRetriever<T> {
    private final RpcService rpcService;
    private final Class<T> gatewayType;
    private final Function<UUID, F> fencingTokenMapper;
    private final RetryStrategy retryStrategy;

    public RpcGatewayRetriever(RpcService rpcService, Class<T> gatewayType, Function<UUID, F> fencingTokenMapper, RetryStrategy retryStrategy) {
        this.rpcService = Preconditions.checkNotNull(rpcService);
        this.gatewayType = Preconditions.checkNotNull(gatewayType);
        this.fencingTokenMapper = Preconditions.checkNotNull(fencingTokenMapper);
        this.retryStrategy = Preconditions.checkNotNull(retryStrategy);
    }

    @Override
    protected CompletableFuture<T> createGateway(CompletableFuture<Tuple2<String, UUID>> leaderFuture) {
        return FutureUtils.retryWithDelay(() -> leaderFuture.thenCompose(addressLeaderTuple -> this.rpcService.connect((String)addressLeaderTuple.f0, (Serializable)this.fencingTokenMapper.apply((UUID)addressLeaderTuple.f1), this.gatewayType)), this.retryStrategy, this.rpcService.getScheduledExecutor());
    }
}

