/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.util;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

@Internal
public final class AssignerWithPunctuatedWatermarksAdapter<T>
implements WatermarkGenerator<T> {
    private final AssignerWithPunctuatedWatermarks<T> wms;

    public AssignerWithPunctuatedWatermarksAdapter(AssignerWithPunctuatedWatermarks<T> wms) {
        this.wms = Preconditions.checkNotNull(wms);
    }

    @Override
    public void onEvent(T event, long eventTimestamp, WatermarkOutput output) {
        Watermark next = this.wms.checkAndGetNextWatermark(event, eventTimestamp);
        if (next != null) {
            output.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(next.getTimestamp()));
        }
    }

    @Override
    public void onPeriodicEmit(WatermarkOutput output) {
    }

    public static final class Strategy<T>
    implements WatermarkStrategy<T> {
        private static final long serialVersionUID = 1L;
        private final AssignerWithPunctuatedWatermarks<T> wms;

        public Strategy(AssignerWithPunctuatedWatermarks<T> wms) {
            this.wms = Preconditions.checkNotNull(wms);
        }

        @Override
        public TimestampAssigner<T> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
            return this.wms;
        }

        @Override
        public WatermarkGenerator<T> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
            return new AssignerWithPunctuatedWatermarksAdapter<T>(this.wms);
        }
    }
}

