/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
public final class NestedRowData
extends BinarySection
implements RowData,
TypedSetters {
    private final int arity;
    private final int nullBitsSizeInBytes;

    public NestedRowData(int arity) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRowData.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        byte kindValue = BinarySegmentUtils.getByte(this.segments, this.offset);
        return RowKind.fromByteValue(kindValue);
    }

    @Override
    public void setRowKind(RowKind kind) {
        BinarySegmentUtils.setByte(this.segments, this.offset, kind.toByteValue());
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        BinarySegmentUtils.bitUnSet(this.segments, this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        BinarySegmentUtils.bitSet(this.segments, this.offset, i + 8);
        BinarySegmentUtils.setLong(this.segments, this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setInt(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setLong(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setDouble(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, DecimalData value, int precision) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(BinarySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            BinarySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                BinarySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                BinarySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, TimestampData value, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            this.setLong(pos, value.getMillisecond());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(BinarySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value == null) {
                this.setNullAt(pos);
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                BinarySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                BinarySegmentUtils.setLong(this.segments, this.offset + cursor, value.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value.getNanoOfMillisecond());
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setBoolean(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setShort(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setByte(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        BinarySegmentUtils.setFloat(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.bitGet(this.segments, this.offset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getBoolean(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getByte(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getShort(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getInt(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getLong(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getFloat(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.getDouble(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public StringData getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readStringData(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (DecimalData.isCompact(precision)) {
            return DecimalData.fromUnscaledLong(BinarySegmentUtils.getLong(this.segments, this.getFieldOffset(pos)), precision, scale);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readDecimalData(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (TimestampData.isCompact(precision)) {
            return TimestampData.fromEpochMillis(BinarySegmentUtils.getLong(this.segments, this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readRawValueData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = BinarySegmentUtils.getLong(this.segments, fieldOffset);
        return BinarySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readRowData(this.segments, numFields, this.offset, this.getLong(pos));
    }

    @Override
    public ArrayData getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public MapData getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinarySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    public NestedRowData copy() {
        return this.copy(new NestedRowData(this.arity));
    }

    public NestedRowData copy(RowData reuse) {
        return this.copyInternal((NestedRowData)reuse);
    }

    private NestedRowData copyInternal(NestedRowData reuse) {
        byte[] bytes = BinarySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NestedRowData) && !(o instanceof BinaryRowData)) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && BinarySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    @Override
    public int hashCode() {
        return BinarySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }
}

