/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.FileStore;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.sink.TableCommit;

public abstract class AbstractFileStoreTable
implements FileStoreTable {
    private static final long serialVersionUID = 1L;
    protected final Path path;
    protected final TableSchema tableSchema;

    public AbstractFileStoreTable(Path path, TableSchema tableSchema) {
        this.path = path;
        this.tableSchema = tableSchema;
    }

    protected abstract FileStore<?> store();

    protected abstract FileStoreTable copy(TableSchema var1);

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        Map<String, String> options = this.tableSchema.options();
        dynamicOptions.forEach((k, v) -> {
            if (!Objects.equals(v, options.get(k))) {
                SchemaManager.checkAlterTableOption(k);
            }
        });
        Configuration newOptions = Configuration.fromMap(options);
        dynamicOptions.forEach(newOptions::setString);
        newOptions.set((ConfigOption)CoreOptions.PATH, this.path.toString());
        CoreOptions.setDefaultValues(newOptions);
        TableSchema newTableSchema = this.tableSchema.copy(newOptions.toMap());
        CoreOptions.validateTableSchema(newTableSchema);
        return this.copy(newTableSchema);
    }

    protected SchemaManager schemaManager() {
        return new SchemaManager(this.path);
    }

    @Override
    public CoreOptions options() {
        return this.store().options();
    }

    @Override
    public Path location() {
        return this.path;
    }

    @Override
    public TableSchema schema() {
        return this.tableSchema;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.store().snapshotManager();
    }

    @Override
    public TableCommit newCommit(String commitUser) {
        return new TableCommit(this.store().newCommit(commitUser), this.options().writeOnly() ? null : this.store().newExpire());
    }
}

