/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.commons.validator.routines.InetAddressValidator;

class InetSocketWrapper {
    String hostName;
    protected InetSocketAddress inetSocketAddress;

    protected InetSocketWrapper() {
    }

    protected InetSocketWrapper(String hostName, int port) {
        this.hostName = hostName;
        this.inetSocketAddress = hostName == null ? new InetSocketAddress(port) : (InetAddressValidator.getInstance().isValid(hostName) ? new InetSocketAddress(hostName, port) : InetSocketAddress.createUnresolved(hostName, port));
    }

    public String getHostName() {
        if (this.hostName != null) {
            return this.hostName;
        }
        return this.inetSocketAddress.getHostName();
    }

    public InetAddress getAddress() {
        return this.getSocketInetAddress().getAddress();
    }

    public int hashCode() {
        return this.inetSocketAddress.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetSocketWrapper that = (InetSocketWrapper)o;
        return Objects.equals(this.inetSocketAddress, that.inetSocketAddress);
    }

    public InetSocketAddress getSocketInetAddress() {
        if (this.inetSocketAddress.isUnresolved()) {
            return new InetSocketAddress(this.inetSocketAddress.getHostString(), this.inetSocketAddress.getPort());
        }
        return this.inetSocketAddress;
    }

    public String toString() {
        return this.inetSocketAddress.toString();
    }
}

