/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsClockFactory;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class IndexStats {
    @Immutable
    private static final StatisticsType type;
    private static final int numKeysId;
    private static final int numValuesId;
    private static final int numUpdatesId;
    private static final int numUsesId;
    private static final int updateTimeId;
    private static final int useTimeId;
    private static final int updatesInProgressId;
    private static final int usesInProgressId;
    private static final int readLockCountId;
    private static final int numMapIndexKeysId;
    private static final int numBucketIndexesId;
    private final Statistics stats;
    private final StatisticsClock clock;

    public IndexStats(StatisticsFactory factory, String indexName) {
        this(factory, indexName, StatisticsClockFactory.clock());
    }

    private IndexStats(StatisticsFactory factory, String indexName, StatisticsClock clock) {
        this.stats = factory.createAtomicStatistics(type, indexName);
        this.clock = clock;
    }

    public long getNumberOfKeys() {
        return this.stats.getLong(numKeysId);
    }

    public long getNumberOfValues() {
        return this.stats.getLong(numValuesId);
    }

    public long getNumUpdates() {
        return this.stats.getLong(numUpdatesId);
    }

    public long getTotalUses() {
        return this.stats.getLong(numUsesId);
    }

    public long getTotalUpdateTime() {
        return this.clock.isEnabled() ? this.stats.getLong(updateTimeId) : 0L;
    }

    public long getUseTime() {
        return this.clock.isEnabled() ? this.stats.getLong(useTimeId) : 0L;
    }

    public long getReadLockCount() {
        return this.stats.getLong(readLockCountId);
    }

    public long getNumberOfMapIndexKeys() {
        return this.stats.getLong(numMapIndexKeysId);
    }

    public long getNumberOfBucketIndexes() {
        return this.stats.getLong(numBucketIndexesId);
    }

    public void incNumUpdates() {
        this.stats.incLong(numUpdatesId, 1L);
    }

    public void incNumUpdates(int delta) {
        this.stats.incLong(numUpdatesId, (long)delta);
    }

    public void incNumValues(int delta) {
        this.stats.incLong(numValuesId, (long)delta);
    }

    public void updateNumKeys(long numKeys) {
        this.stats.setLong(numKeysId, numKeys);
    }

    public void incNumKeys(long numKeys) {
        this.stats.incLong(numKeysId, numKeys);
    }

    public void incUpdateTime(long delta) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(updateTimeId, delta);
        }
    }

    public void incNumUses() {
        this.stats.incLong(numUsesId, 1L);
    }

    public void incUpdatesInProgress(int delta) {
        this.stats.incLong(updatesInProgressId, (long)delta);
    }

    public void incUsesInProgress(int delta) {
        this.stats.incLong(usesInProgressId, (long)delta);
    }

    public void incUseTime(long delta) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(useTimeId, delta);
        }
    }

    public void incReadLockCount(int delta) {
        this.stats.incLong(readLockCountId, (long)delta);
    }

    public void incNumMapIndexKeys(long delta) {
        this.stats.incLong(numMapIndexKeysId, delta);
    }

    public void incNumBucketIndexes(int delta) {
        this.stats.incLong(numBucketIndexesId, (long)delta);
    }

    void close() {
        this.stats.close();
    }

    public boolean isClosed() {
        return this.stats.isClosed();
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String numKeysDesc = "Number of keys in this index";
        String numValuesDesc = "Number of values in this index";
        String numUpdatesDesc = "Number of updates that have completed on this index";
        String numUsesDesc = "Number of times this index has been used while executing a query";
        String updateTimeDesc = "Total time spent updating this index";
        type = f.createType("IndexStats", "Statistics about a query index", new StatisticDescriptor[]{f.createLongGauge("numKeys", "Number of keys in this index", "keys"), f.createLongGauge("numValues", "Number of values in this index", "values"), f.createLongCounter("numUpdates", "Number of updates that have completed on this index", "operations"), f.createLongCounter("numUses", "Number of times this index has been used while executing a query", "operations"), f.createLongCounter("updateTime", "Total time spent updating this index", "nanoseconds"), f.createLongCounter("useTime", "Total time spent using this index", "nanoseconds"), f.createLongGauge("updatesInProgress", "Current number of updates in progress.", "updates"), f.createLongGauge("usesInProgress", "Current number of uses in progress.", "uses"), f.createLongGauge("readLockCount", "Current number of read locks taken.", "uses"), f.createLongGauge("numMapIndexKeys", "Number of keys in this Map index", "keys"), f.createLongGauge("numBucketIndexes", "Number of bucket indexes in the partitioned region", "indexes")});
        numKeysId = type.nameToId("numKeys");
        numValuesId = type.nameToId("numValues");
        numUpdatesId = type.nameToId("numUpdates");
        numUsesId = type.nameToId("numUses");
        updateTimeId = type.nameToId("updateTime");
        updatesInProgressId = type.nameToId("updatesInProgress");
        usesInProgressId = type.nameToId("usesInProgress");
        useTimeId = type.nameToId("useTime");
        readLockCountId = type.nameToId("readLockCount");
        numMapIndexKeysId = type.nameToId("numMapIndexKeys");
        numBucketIndexesId = type.nameToId("numBucketIndexes");
    }
}

