/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.iceberg.hive.HiveCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosableHiveCatalog
extends HiveCatalog
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClosableHiveCatalog.class);
    private final List<Closeable> resources = Lists.newArrayList();

    public void addResource(Closeable resource) {
        this.resources.add(resource);
    }

    @Override
    public void close() throws IOException {
        this.resources.forEach(resource -> {
            try {
                if (resource != null) {
                    resource.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close resource: {}", resource, (Object)e);
            }
        });
    }
}

