/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.datasources;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.hbase.spark.datasources.Field;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableCatalog;
import org.apache.hadoop.hbase.spark.datasources.RowKey;
import org.apache.hadoop.hbase.spark.datasources.SchemaMap;
import org.apache.hadoop.hbase.spark.datasources.SchemaQualifierDefinition;
import org.apache.hadoop.hbase.spark.datasources.SerDes;
import org.apache.yetus.audience.InterfaceAudience;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@InterfaceAudience.Public
public final class HBaseTableCatalog$
implements scala.Serializable {
    public static HBaseTableCatalog$ MODULE$;
    private final String newTable;
    private final String regionStart;
    private final String defaultRegionStart;
    private final String regionEnd;
    private final String defaultRegionEnd;
    private final String tableCatalog;
    private final String rowKey;
    private final String table;
    private final String nameSpace;
    private final String tableName;
    private final String columns;
    private final String cf;
    private final String col;
    private final String type;
    private final String avro;
    private final byte delimiter;
    private final String serdes;
    private final String length;
    private final String TABLE_KEY;
    private final String SCHEMA_COLUMNS_MAPPING_KEY;

    static {
        new HBaseTableCatalog$();
    }

    public String newTable() {
        return this.newTable;
    }

    public String regionStart() {
        return this.regionStart;
    }

    public String defaultRegionStart() {
        return this.defaultRegionStart;
    }

    public String regionEnd() {
        return this.regionEnd;
    }

    public String defaultRegionEnd() {
        return this.defaultRegionEnd;
    }

    public String tableCatalog() {
        return this.tableCatalog;
    }

    public String rowKey() {
        return this.rowKey;
    }

    public String table() {
        return this.table;
    }

    public String nameSpace() {
        return this.nameSpace;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columns() {
        return this.columns;
    }

    public String cf() {
        return this.cf;
    }

    public String col() {
        return this.col;
    }

    public String type() {
        return this.type;
    }

    public String avro() {
        return this.avro;
    }

    public byte delimiter() {
        return this.delimiter;
    }

    public String serdes() {
        return this.serdes;
    }

    public String length() {
        return this.length;
    }

    public HBaseTableCatalog apply(Map<String, String> params) {
        Map<String, String> parameters = this.convert(params);
        String jString = (String)parameters.apply((Object)this.tableCatalog());
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue map = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(jString), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        JsonAST.JValue tableMeta = package$.MODULE$.jvalue2monadic(map).$bslash(this.table());
        String nSpace = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(tableMeta).$bslash(this.nameSpace())).extractOrElse((Function0 & Serializable & scala.Serializable)() -> "default", (Formats)formats, ManifestFactory$.MODULE$.classType(String.class));
        String tName = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(tableMeta).$bslash(this.tableName())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(String.class));
        Map cIter = (Map)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(map).$bslash(this.columns())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(String.class)}))})));
        scala.collection.mutable.HashMap schemaMap = HashMap$.MODULE$.empty();
        cIter.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Map column = (Map)tuple2._2();
            Option sd = column.get((Object)MODULE$.serdes()).map((Function1 & Serializable & scala.Serializable)n -> (SerDes)Class.forName(n).newInstance());
            int len = BoxesRunTime.unboxToInt((Object)column.get((Object)MODULE$.length()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)HBaseTableCatalog$.$anonfun$apply$4(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            Option sAvro = column.get((Object)MODULE$.avro()).map((Function1 & Serializable & scala.Serializable)x$9 -> (String)parameters.apply(x$9));
            Field f = new Field(name, (String)column.getOrElse((Object)MODULE$.cf(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.rowKey()), (String)column.get((Object)MODULE$.col()).get(), (Option<String>)column.get((Object)MODULE$.type()), (Option<String>)sAvro, (Option<SerDes>)sd, len);
            scala.collection.mutable.HashMap hashMap = schemaMap.$plus$eq(new Tuple2((Object)name, (Object)f));
            return hashMap;
        });
        RowKey rKey = new RowKey((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(map).$bslash(this.rowKey())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(String.class)));
        return new HBaseTableCatalog(nSpace, tName, rKey, new SchemaMap((scala.collection.mutable.HashMap<String, Field>)schemaMap), parameters);
    }

    public String TABLE_KEY() {
        return this.TABLE_KEY;
    }

    public String SCHEMA_COLUMNS_MAPPING_KEY() {
        return this.SCHEMA_COLUMNS_MAPPING_KEY;
    }

    public Map<String, String> convert(Map<String, String> parameters) {
        String string;
        String nsTableName = (String)parameters.get((Object)this.TABLE_KEY()).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
        if (nsTableName == null) {
            return parameters;
        }
        String[] tableParts = new StringOps(Predef$.MODULE$.augmentString(nsTableName.trim())).split(':');
        if (tableParts.length == 1) {
            string = "default";
        } else if (tableParts.length == 2) {
            string = tableParts[0];
        } else {
            throw new IllegalArgumentException(new StringBuilder(65).append("Invalid table name '").append(nsTableName).append("' should be '<namespace>:<name>' or '<name>' ").toString());
        }
        String tableNamespace = string;
        String tableName = tableParts[tableParts.length - 1];
        String schemaMappingString = (String)parameters.getOrElse((Object)this.SCHEMA_COLUMNS_MAPPING_KEY(), (Function0 & Serializable & scala.Serializable)() -> "");
        Iterable schemaMap = (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.generateSchemaMappingMap(schemaMappingString)).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> (SchemaQualifierDefinition)x$10._2(), Iterable$.MODULE$.canBuildFrom());
        Iterable rowkey = (Iterable)((TraversableLike)schemaMap.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HBaseTableCatalog$.$anonfun$convert$4(x$11)))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.columnName(), Iterable$.MODULE$.canBuildFrom());
        Iterable cols = (Iterable)schemaMap.map((Function1 & Serializable & scala.Serializable)x -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(33).append("\"").append(x.columnName()).append("\":{\"cf\":\"").append(x.columnFamily()).append("\", \"col\":\"").append(x.qualifier()).append("\", \"type\":\"").append(x.colType()).append("\"}").toString())).stripMargin(), Iterable$.MODULE$.canBuildFrom());
        String jsonCatalog = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("{\n         |\"table\":{\"namespace\":\"").append(tableNamespace).append("\", \"name\":\"").append(tableName).append("\"},\n         |\"rowkey\":\"").append(rowkey.mkString(":")).append("\",\n         |\"columns\":{\n         |").append(cols.mkString(",")).append("\n         |}\n         |}\n       ").toString())).stripMargin();
        return parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tableCatalog()), (Object)jsonCatalog)})));
    }

    /*
     * WARNING - void declaration
     */
    @InterfaceAudience.Private
    public HashMap<String, SchemaQualifierDefinition> generateSchemaMappingMap(String schemaMappingString) {
        void v0;
        Predef$.MODULE$.println((Object)schemaMappingString);
        try {
            void var3_3;
            String[] columnDefinitions = new StringOps(Predef$.MODULE$.augmentString(schemaMappingString)).split(',');
            HashMap resultingMap = new HashMap();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnDefinitions)).map((Function1 & Serializable & scala.Serializable)cd -> {
                String[] parts = new StringOps(Predef$.MODULE$.augmentString(cd.trim())).split(' ');
                if (parts.length != 3) {
                    throw new IllegalArgumentException(new StringBuilder(169).append("Invalid value for schema mapping '").append((String)cd).append("' should be '<columnName> <columnType> <columnFamily>:<qualifier>' ").append("for columns and '<columnName> <columnType> :<qualifier>' for rowKeys").toString());
                }
                String[] hbaseDefinitionParts = parts[2].charAt(0) == ':' ? (String[])((Object[])new String[]{"rowkey", parts[0]}) : new StringOps(Predef$.MODULE$.augmentString(parts[2])).split(':');
                return resultingMap.put(parts[0], new SchemaQualifierDefinition(parts[0], parts[1], hbaseDefinitionParts[0], hbaseDefinitionParts[1]));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SchemaQualifierDefinition.class)));
            v0 = var3_3;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(21).append("Invalid value for ").append(this.SCHEMA_COLUMNS_MAPPING_KEY()).append(" '").append(schemaMappingString).append("'").toString(), e);
        }
        return v0;
    }

    public HBaseTableCatalog apply(String namespace, String name, RowKey row, SchemaMap sMap, Map<String, String> params) {
        return new HBaseTableCatalog(namespace, name, row, sMap, params);
    }

    public Option<Tuple5<String, String, RowKey, SchemaMap, Map<String, String>>> unapply(HBaseTableCatalog x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.namespace(), (Object)x$0.name(), (Object)x$0.row(), (Object)x$0.sMap(), x$0.params()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$apply$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$convert$4(SchemaQualifierDefinition x$11) {
        String string = x$11.columnFamily();
        String string2 = "rowkey";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private HBaseTableCatalog$() {
        MODULE$ = this;
        this.newTable = "newtable";
        this.regionStart = "regionStart";
        this.defaultRegionStart = "aaaaaaa";
        this.regionEnd = "regionEnd";
        this.defaultRegionEnd = "zzzzzzz";
        this.tableCatalog = "catalog";
        this.rowKey = "rowkey";
        this.table = "table";
        this.nameSpace = "namespace";
        this.tableName = "name";
        this.columns = "columns";
        this.cf = "cf";
        this.col = "col";
        this.type = "type";
        this.avro = "avro";
        this.delimiter = 0;
        this.serdes = "serdes";
        this.length = "length";
        this.TABLE_KEY = "hbase.table";
        this.SCHEMA_COLUMNS_MAPPING_KEY = "hbase.columns.mapping";
    }
}

