/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.RegionReplicaCandidateGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicaRackCandidateGenerator
extends RegionReplicaCandidateGenerator {
    RegionReplicaRackCandidateGenerator() {
    }

    @Override
    BalanceAction generate(BalancerClusterState cluster) {
        int rackIndex = this.pickRandomRack(cluster);
        if (cluster.numRacks <= 1 || rackIndex == -1) {
            return super.generate(cluster);
        }
        int regionIndex = this.selectCoHostedRegionPerGroup(cluster.colocatedReplicaCountsPerRack[rackIndex], cluster.regionsPerRack[rackIndex], cluster.regionIndexToPrimaryIndex);
        if (regionIndex == -1) {
            return this.randomGenerator.generate(cluster);
        }
        int serverIndex = cluster.regionIndexToServerIndex[regionIndex];
        int toRackIndex = this.pickOtherRandomRack(cluster, rackIndex);
        int rand = ThreadLocalRandom.current().nextInt(cluster.serversPerRack[toRackIndex].length);
        int toServerIndex = cluster.serversPerRack[toRackIndex][rand];
        int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
        return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
    }
}

