/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRollbackException;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.model.Message;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitor;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.StatusUpdateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixTask
implements MessageTask {
    private static Logger logger = LoggerFactory.getLogger(HelixTask.class);
    private final Message _message;
    private final MessageHandler _handler;
    private final NotificationContext _notificationContext;
    private final HelixManager _manager;
    StatusUpdateUtil _statusUpdateUtil;
    HelixTaskExecutor _executor;
    volatile boolean _isTimeout = false;
    volatile boolean _isStarted = false;
    volatile boolean _isCancelled = false;

    public HelixTask(Message message, NotificationContext notificationContext, MessageHandler handler, HelixTaskExecutor executor) {
        this._notificationContext = notificationContext;
        this._message = message;
        this._handler = handler;
        this._manager = notificationContext.getManager();
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public HelixTaskResult call() {
        block26: {
            block28: {
                taskResult = null;
                type = null;
                code = null;
                handlerStart = null;
                handlerEnd = null;
                start = System.currentTimeMillis();
                HelixTask.logger.info("handling task: " + this.getTaskId() + " begin, at: " + start);
                this._statusUpdateUtil.logInfo(this._message, HelixTask.class, "Message handling task begin execute", this._manager);
                this._message.setExecuteStartTimeStamp(new Date().getTime());
                if (this._message.getBatchMessageMode()) {
                    this._notificationContext.add(NotificationContext.MapKey.CURRENT_STATE_UPDATE.toString(), new ConcurrentHashMap<K, V>());
                }
                try {
                    this.setStarted();
                    handlerStart = System.currentTimeMillis();
                    taskResult = this._handler.handleMessage();
                    handlerEnd = System.currentTimeMillis();
                    this._executor.cancelTimeoutTask(this);
                }
                catch (InterruptedException e) {
                    taskResult = new HelixTaskResult();
                    taskResult.setException(e);
                    taskResult.setInterrupted(true);
                    this._statusUpdateUtil.logError(this._message, HelixTask.class, (Exception)e, "State transition interrupted, timeout:" + this._isTimeout, this._manager);
                    HelixTask.logger.info("Message " + this._message.getMsgId() + " is interrupted");
                }
                catch (Exception e) {
                    taskResult = new HelixTaskResult();
                    taskResult.setException(e);
                    taskResult.setMessage(e.getMessage());
                    errorMessage = "Exception while executing a message. " + e + " msgId: " + this._message.getMsgId() + " type: " + this._message.getMsgType();
                    HelixTask.logger.error(errorMessage, (Throwable)e);
                    this._statusUpdateUtil.logError(this._message, HelixTask.class, e, errorMessage, this._manager);
                }
                exception = null;
                if (!taskResult.isSuccess()) break block28;
                this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Message handling task completed successfully", this._manager);
                HelixTask.logger.info("Message " + this._message.getMsgId() + " completed.");
                this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
                ** GOTO lbl80
            }
            type = MessageHandler.ErrorType.INTERNAL;
            if (!taskResult.isInterrupted()) ** GOTO lbl70
            HelixTask.logger.info("Message " + this._message.getMsgId() + " is interrupted");
            v0 = code = this._isTimeout != false ? MessageHandler.ErrorCode.TIMEOUT : MessageHandler.ErrorCode.CANCEL;
            if (!this._isTimeout) break block26;
            retryCount = this._message.getRetryCount();
            HelixTask.logger.info("Message timeout, retry count: " + retryCount + " msgId:" + this._message.getMsgId());
            this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Message handling task timeout, retryCount:" + retryCount, this._manager);
            if (retryCount <= 0) break block26;
            this._message.setRetryCount(retryCount - 1);
            task = new HelixTask(this._message, this._notificationContext, this._handler, this._executor);
            this._executor.scheduleTask(task);
            var11_19 = taskResult;
            end = System.currentTimeMillis();
            totalDuration = end - start;
            handlerDuration = handlerStart != null && handlerEnd != null ? handlerEnd - handlerStart : -1L;
            HelixTask.logger.info("Message: {} (parent: {}) handling task for {}:{} completed at: {}, results: {}. FrameworkTime: {} ms; HandlerTime: {} ms.", new Object[]{this._message.getMsgId(), this._message.getAttribute(Message.Attributes.PARENT_MSG_ID), this._message.getResourceName(), this._message.getPartitionName(), end, taskResult.isSuccess(), totalDuration - handlerDuration, handlerDuration});
            if (type == MessageHandler.ErrorType.INTERNAL) {
                this._handler.onError(taskResult.getException(), code, type);
            } else if (type == MessageHandler.ErrorType.FRAMEWORK) {
                this._handler.onError(exception, code, type);
            }
            return var11_19;
        }
        try {
            block29: {
                this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                break block29;
lbl70:
                // 1 sources

                if (taskResult.isCancelled()) {
                    type = null;
                    this._statusUpdateUtil.logInfo(this._message, this._handler.getClass(), "Cancellation completed successfully", this._manager);
                    this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                } else {
                    code = MessageHandler.ErrorCode.ERROR;
                    errorMsg = "Message execution failed. msgId: " + this.getTaskId() + ", errorMsg: " + taskResult.getMessage();
                    HelixTask.logger.error(errorMsg);
                    this._statusUpdateUtil.logError(this._message, this._handler.getClass(), errorMsg, this._manager);
                    this._executor.getParticipantMonitor().reportProcessedMessage(this._message, ParticipantMessageMonitor.ProcessedMessageState.FAILED);
                }
            }
            accessor = this._manager.getHelixDataAccessor();
            if (taskResult.isSuccess()) {
                try {
                    this.forwardRelayMessages(accessor, this._message, taskResult.getCompleteTime());
                }
                catch (Exception e) {
                    HelixTask.logger.warn("Failed to send relay messages.", (Throwable)e);
                }
            }
            this.finalCleanup(taskResult);
        }
        catch (Exception e) {
            try {
                this.finalCleanup(taskResult);
                exception = e;
                type = MessageHandler.ErrorType.FRAMEWORK;
                code = MessageHandler.ErrorCode.ERROR;
                errorMessage = "Exception after executing a message, msgId: " + this._message.getMsgId() + e;
                HelixTask.logger.error(errorMessage, (Throwable)e);
                this._statusUpdateUtil.logError(this._message, HelixTask.class, errorMessage, this._manager);
            }
            catch (Throwable var18_27) {
                end = System.currentTimeMillis();
                totalDuration = end - start;
                handlerDuration = handlerStart != null && handlerEnd != null ? handlerEnd - handlerStart : -1L;
                HelixTask.logger.info("Message: {} (parent: {}) handling task for {}:{} completed at: {}, results: {}. FrameworkTime: {} ms; HandlerTime: {} ms.", new Object[]{this._message.getMsgId(), this._message.getAttribute(Message.Attributes.PARENT_MSG_ID), this._message.getResourceName(), this._message.getPartitionName(), end, taskResult.isSuccess(), totalDuration - handlerDuration, handlerDuration});
                if (type == MessageHandler.ErrorType.INTERNAL) {
                    this._handler.onError(taskResult.getException(), code, type);
                } else if (type == MessageHandler.ErrorType.FRAMEWORK) {
                    this._handler.onError(exception, code, type);
                }
                throw var18_27;
            }
            end = System.currentTimeMillis();
            totalDuration = end - start;
            handlerDuration = handlerStart != null && handlerEnd != null ? handlerEnd - handlerStart : -1L;
            HelixTask.logger.info("Message: {} (parent: {}) handling task for {}:{} completed at: {}, results: {}. FrameworkTime: {} ms; HandlerTime: {} ms.", new Object[]{this._message.getMsgId(), this._message.getAttribute(Message.Attributes.PARENT_MSG_ID), this._message.getResourceName(), this._message.getPartitionName(), end, taskResult.isSuccess(), totalDuration - handlerDuration, handlerDuration});
            if (type == MessageHandler.ErrorType.INTERNAL) {
                this._handler.onError(taskResult.getException(), code, type);
            } else if (type == MessageHandler.ErrorType.FRAMEWORK) {
                this._handler.onError(exception, code, type);
            } else {
                ** GOTO lbl129
            }
        }
        end = System.currentTimeMillis();
        totalDuration = end - start;
        handlerDuration = handlerStart != null && handlerEnd != null ? handlerEnd - handlerStart : -1L;
        HelixTask.logger.info("Message: {} (parent: {}) handling task for {}:{} completed at: {}, results: {}. FrameworkTime: {} ms; HandlerTime: {} ms.", new Object[]{this._message.getMsgId(), this._message.getAttribute(Message.Attributes.PARENT_MSG_ID), this._message.getResourceName(), this._message.getPartitionName(), end, taskResult.isSuccess(), totalDuration - handlerDuration, handlerDuration});
        if (type == MessageHandler.ErrorType.INTERNAL) {
            this._handler.onError(taskResult.getException(), code, type);
        } else if (type == MessageHandler.ErrorType.FRAMEWORK) {
            this._handler.onError(exception, code, type);
        }
        return taskResult;
    }

    private void removeMessageFromZk(HelixDataAccessor accessor, Message message) {
        if (!HelixUtil.removeMessageFromZK(accessor, message, this._manager.getInstanceName())) {
            logger.warn("Failed to delete message " + message.getId() + " from zk!");
        } else {
            logger.info("Delete message " + message.getId() + " from zk!");
        }
    }

    private void forwardRelayMessages(HelixDataAccessor accessor, Message message, long taskCompletionTime) {
        if (message.hasRelayMessages()) {
            Map<String, Message> relayMessages = message.getRelayMessages();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            if (!this._manager.getSessionId().equals(message.getTgtSessionId())) {
                logger.info("Session id has been changed, ignore all relay messages attached with " + message.getId());
                return;
            }
            for (String instance : relayMessages.keySet()) {
                Message msg = relayMessages.get(instance);
                if (!msg.getMsgSubType().equals(Message.MessageType.RELAYED_MESSAGE.name())) continue;
                msg.setRelayTime(taskCompletionTime);
                if (msg.isExpired()) {
                    logger.info("Relay message expired, ignore " + msg.getId() + " to instance " + instance);
                    continue;
                }
                PropertyKey msgKey = keyBuilder.message(instance, msg.getId());
                boolean success = accessor.getBaseDataAccessor().create(msgKey.getPath(), msg.getRecord(), AccessOption.PERSISTENT);
                if (!success) {
                    logger.warn("Failed to send relay message " + msg.getId() + " to " + instance);
                    continue;
                }
                logger.info("Send relay message " + msg.getId() + " to " + instance);
            }
        }
    }

    private HelixDataAccessor getSrcClusterDataAccessor(Message message) {
        HelixDataAccessor helixDataAccessor = this._manager.getHelixDataAccessor();
        String clusterName = message.getSrcClusterName();
        if (clusterName != null && !clusterName.equals(this._manager.getClusterName())) {
            helixDataAccessor = new ZKHelixDataAccessor(clusterName, helixDataAccessor.getBaseDataAccessor());
        }
        return helixDataAccessor;
    }

    private void sendReply(HelixDataAccessor replyDataAccessor, Message message, HelixTaskResult taskResult) {
        if (message.getCorrelationId() != null && !message.getMsgType().equals(Message.MessageType.TASK_REPLY.name())) {
            logger.info("Sending reply for message " + message.getCorrelationId());
            this._statusUpdateUtil.logInfo(message, HelixTask.class, "Sending reply", this._manager);
            taskResult.getTaskResultMap().put("SUCCESS", "" + taskResult.isSuccess());
            taskResult.getTaskResultMap().put("INTERRUPTED", "" + taskResult.isInterrupted());
            if (!taskResult.isSuccess()) {
                taskResult.getTaskResultMap().put("ERRORINFO", taskResult.getMessage());
            }
            Message replyMessage = Message.createReplyMessage(message, this._manager.getInstanceName(), taskResult.getTaskResultMap());
            replyMessage.setSrcInstanceType(this._manager.getInstanceType());
            PropertyKey.Builder keyBuilder = replyDataAccessor.keyBuilder();
            if (message.getSrcInstanceType() == InstanceType.PARTICIPANT) {
                replyDataAccessor.setProperty(keyBuilder.message(message.getMsgSrc(), replyMessage.getMsgId()), replyMessage);
            } else if (message.getSrcInstanceType() == InstanceType.CONTROLLER) {
                replyDataAccessor.setProperty(keyBuilder.controllerMessage(replyMessage.getMsgId()), replyMessage);
            }
            this._statusUpdateUtil.logInfo(message, HelixTask.class, String.format("1 msg replied to %s in cluster %s.", replyMessage.getTgtName(), message.getSrcClusterName() == null ? this._manager.getClusterName() : message.getSrcClusterName()), this._manager);
        }
    }

    private void reportMessageStat(HelixManager manager, Message message, HelixTaskResult taskResult) {
        if (!message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            return;
        }
        long now = new Date().getTime();
        long msgReadTime = message.getReadTimeStamp();
        long msgExecutionStartTime = message.getExecuteStartTimeStamp();
        if (msgReadTime != 0L && msgExecutionStartTime != 0L) {
            long totalDelay = now - msgReadTime;
            long executionDelay = now - msgExecutionStartTime;
            long msgLatency = msgReadTime - message.getCreateTimeStamp();
            if (totalDelay >= 0L && executionDelay >= 0L) {
                String fromState = message.getFromState();
                String toState = message.getToState();
                String transition = fromState + "--" + toState;
                StateTransitionContext cxt = new StateTransitionContext(manager.getClusterName(), manager.getInstanceName(), message.getResourceName(), transition);
                StateTransitionDataPoint data = new StateTransitionDataPoint(totalDelay, executionDelay, msgLatency, taskResult.isSuccess());
                this._executor.getParticipantMonitor().reportTransitionStat(cxt, data);
            }
        } else {
            logger.warn("message read time and start execution time not recorded. State transition delay time is not available, message read time {}, Execute start time {}.", (Object)msgReadTime, (Object)msgExecutionStartTime);
        }
    }

    @Override
    public String getTaskId() {
        return this._message.getId();
    }

    @Override
    public Message getMessage() {
        return this._message;
    }

    @Override
    public NotificationContext getNotificationContext() {
        return this._notificationContext;
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
        this._handler.onTimeout();
    }

    @Override
    public synchronized boolean cancel() {
        if (!this._isStarted) {
            this._isCancelled = true;
            this._handler.cancel();
            return true;
        }
        return false;
    }

    private synchronized void setStarted() {
        if (this._isCancelled) {
            throw new HelixRollbackException("Task has already been cancelled");
        }
        this._isStarted = true;
    }

    private void finalCleanup(HelixTaskResult taskResult) {
        try {
            if (this._message.getAttribute(Message.Attributes.PARENT_MSG_ID) == null) {
                this.removeMessageFromZk(this._manager.getHelixDataAccessor(), this._message);
                this.reportMessageStat(this._manager, this._message, taskResult);
                this.sendReply(this.getSrcClusterDataAccessor(this._message), this._message, taskResult);
                this._executor.finishTask(this);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error to final clean up for message : %s", this._message.getId()));
        }
    }
}

