/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Iterator;
import org.snmp4j.log.LogLevel;

public interface LogAdapter {
    public boolean isDebugEnabled();

    public boolean isInfoEnabled();

    public boolean isWarnEnabled();

    public void debug(Serializable var1);

    public void info(CharSequence var1);

    public void warn(Serializable var1);

    public void error(Serializable var1);

    public void error(CharSequence var1, Throwable var2);

    public void fatal(Object var1);

    public void fatal(CharSequence var1, Throwable var2);

    default public void log(LogLevel logLevel, CharSequence message, Throwable throwable) {
        if (this.isLogLevelEnabled(logLevel)) {
            switch (logLevel.getLevel()) {
                case 4: {
                    this.debug((Serializable)((Object)message));
                    break;
                }
                case 5: {
                    this.info(message);
                    break;
                }
                case 6: {
                    this.warn((Serializable)((Object)message));
                    break;
                }
                case 7: {
                    this.error(message, throwable);
                }
            }
        }
    }

    default public boolean isLogLevelEnabled(LogLevel logLevel) {
        switch (logLevel.getLevel()) {
            case 4: {
                return this.isDebugEnabled();
            }
            case 5: {
                return this.isInfoEnabled();
            }
            case 6: {
                return this.isWarnEnabled();
            }
            case 7: {
                return this.getEffectiveLogLevel() != LogLevel.OFF;
            }
        }
        return false;
    }

    public void setLogLevel(LogLevel var1);

    public LogLevel getLogLevel();

    public LogLevel getEffectiveLogLevel();

    public String getName();

    public Iterator<?> getLogHandler();

    default public void removeAllHandlers() {
    }

    default public void setLogHandler(String logHandlerList) {
    }
}

