/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.limit;

import com.codahale.metrics.Histogram;
import io.greptime.Util;
import io.greptime.common.util.MetricsUtil;
import io.greptime.limit.InFlightLimiter;
import io.greptime.limit.LimitedPolicy;
import io.greptime.limit.Limiter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public abstract class AbstractLimiter<In, Out> {
    private final Limiter limiter;
    private final LimitedPolicy policy;
    private final Histogram acquireAvailablePermits;

    public AbstractLimiter(int maxInFlight, LimitedPolicy policy, String metricPrefix) {
        this.limiter = maxInFlight > 0 ? new InFlightLimiter(maxInFlight, metricPrefix) : null;
        this.policy = policy;
        this.acquireAvailablePermits = MetricsUtil.histogram((Object[])new Object[]{metricPrefix, "available_permits"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Out> acquireAndDo(In in, Supplier<CompletableFuture<Out>> action) {
        int maxPermits;
        if (this.limiter == null || this.policy == null) {
            return action.get();
        }
        int acquirePermits = this.calculatePermits(in);
        int permits = Math.min(acquirePermits, maxPermits = this.limiter.maxPermits());
        if (permits <= 0) {
            return action.get();
        }
        try {
            if (this.policy.acquire(this.limiter, permits)) {
                CompletionStage completionStage = action.get().whenComplete((r, e) -> this.release(permits));
                return completionStage;
            }
            CompletableFuture<Out> completableFuture = Util.completedCf(this.rejected(in, acquirePermits, maxPermits));
            return completableFuture;
        }
        finally {
            this.acquireAvailablePermits.update(this.limiter.availablePermits());
        }
    }

    public abstract int calculatePermits(In var1);

    public abstract Out rejected(In var1, RejectedState var2);

    private Out rejected(In in, int acquirePermits, int maxPermits) {
        return this.rejected(in, new RejectedState(acquirePermits, maxPermits, this.limiter.availablePermits()));
    }

    private void release(int permits) {
        this.limiter.release(permits);
    }

    public static final class RejectedState {
        private final int acquirePermits;
        private final int maxPermits;
        private final int availablePermits;

        public RejectedState(int acquirePermits, int maxPermits, int availablePermits) {
            this.acquirePermits = acquirePermits;
            this.maxPermits = maxPermits;
            this.availablePermits = availablePermits;
        }

        public int acquirePermits() {
            return this.acquirePermits;
        }

        public int maxPermits() {
            return this.maxPermits;
        }

        public int availablePermits() {
            return this.availablePermits;
        }
    }
}

