/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import reactor.core.publisher.Traces;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class CallSiteSupplierFactory
implements Supplier<Supplier<String>>,
Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame[]> {
    CallSiteSupplierFactory() {
    }

    @Override
    public StackWalker.StackFrame[] apply(Stream<StackWalker.StackFrame> s) {
        StackWalker.StackFrame[] result = new StackWalker.StackFrame[10];
        Iterator iterator = s.iterator();
        iterator.next();
        int i = 0;
        while (iterator.hasNext()) {
            StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator.next();
            if (i >= result.length) {
                return new StackWalker.StackFrame[0];
            }
            result[i++] = frame;
            if (!Traces.isUserCode(frame.getClassName())) continue;
            break;
        }
        StackWalker.StackFrame[] copy = new StackWalker.StackFrame[i];
        System.arraycopy(result, 0, copy, 0, i);
        return copy;
    }

    @Override
    public Supplier<String> get() {
        StackWalker.StackFrame[] stack = StackWalker.getInstance().walk(this);
        if (stack.length == 0) {
            return () -> "";
        }
        if (stack.length == 1) {
            return () -> "\t" + stack[0].toString() + "\n";
        }
        return () -> {
            StringBuilder sb = new StringBuilder();
            for (int j = stack.length - 2; j > 0; --j) {
                String previousRow;
                StackWalker.StackFrame previous = stack[j];
                if (!Traces.full && (previous.isNativeMethod() || Traces.shouldSanitize(previousRow = previous.getClassName() + "." + previous.getMethodName()))) continue;
                sb.append("\t").append(previous.toString()).append("\n");
                break;
            }
            sb.append("\t").append(stack[stack.length - 1].toString()).append("\n");
            return sb.toString();
        };
    }

    static {
        StackWalker.getInstance();
    }
}

