/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.PreFlightRequestHandler;
import org.springframework.web.reactive.DispatchExceptionHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DispatcherHandler
implements WebHandler,
PreFlightRequestHandler,
ApplicationContextAware {
    @Nullable
    private List<HandlerMapping> handlerMappings;
    @Nullable
    private List<HandlerAdapter> handlerAdapters;
    @Nullable
    private List<HandlerResultHandler> resultHandlers;

    public DispatcherHandler() {
    }

    public DispatcherHandler(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    @Nullable
    public final List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    protected void initStrategies(ApplicationContext context) {
        Map mappingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
        ArrayList mappings = new ArrayList(mappingBeans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        this.handlerMappings = Collections.unmodifiableList(mappings);
        Map adapterBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
        this.handlerAdapters = new ArrayList(adapterBeans.values());
        AnnotationAwareOrderComparator.sort(this.handlerAdapters);
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerResultHandler.class, (boolean)true, (boolean)false);
        this.resultHandlers = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(this.resultHandlers);
    }

    public Mono<Void> handle(ServerWebExchange exchange2) {
        if (this.handlerMappings == null) {
            return this.createNotFoundError();
        }
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange2.getRequest())) {
            return this.handlePreFlight(exchange2);
        }
        return Flux.fromIterable(this.handlerMappings).concatMap(mapping -> mapping.getHandler(exchange2)).next().switchIfEmpty(this.createNotFoundError()).onErrorResume(ex -> this.handleResultMono(exchange2, (Mono<HandlerResult>)Mono.error((Throwable)ex))).flatMap(handler -> this.handleRequestWith(exchange2, handler));
    }

    private <R> Mono<R> createNotFoundError() {
        return Mono.defer(() -> {
            ResponseStatusException ex = new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            return Mono.error((Throwable)ex);
        });
    }

    private Mono<Void> handleResultMono(ServerWebExchange exchange2, Mono<HandlerResult> resultMono) {
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!(adapter instanceof DispatchExceptionHandler)) continue;
                DispatchExceptionHandler exceptionHandler = (DispatchExceptionHandler)((Object)adapter);
                resultMono = resultMono.onErrorResume(ex2 -> exceptionHandler.handleError(exchange2, (Throwable)ex2));
            }
        }
        return resultMono.flatMap(result -> {
            Mono voidMono = this.handleResult(exchange2, (HandlerResult)result, "Handler " + result.getHandler());
            DispatchExceptionHandler exceptionHandler = result.getExceptionHandler();
            if (exceptionHandler != null) {
                voidMono = voidMono.onErrorResume(ex -> exceptionHandler.handleError(exchange2, (Throwable)ex).flatMap(result2 -> this.handleResult(exchange2, (HandlerResult)result2, "Exception handler " + result2.getHandler() + ", error=\"" + ex.getMessage() + "\"")));
            }
            return voidMono;
        });
    }

    private Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult handlerResult, String description) {
        if (this.resultHandlers != null) {
            for (HandlerResultHandler resultHandler : this.resultHandlers) {
                if (!resultHandler.supports(handlerResult)) continue;
                description = (String)description + " [DispatcherHandler]";
                return resultHandler.handleResult(exchange2, handlerResult).checkpoint((String)description);
            }
        }
        return Mono.error((Throwable)new IllegalStateException("No HandlerResultHandler for " + handlerResult.getReturnValue()));
    }

    private Mono<Void> handleRequestWith(ServerWebExchange exchange2, Object handler) {
        if (ObjectUtils.nullSafeEquals((Object)exchange2.getResponse().getStatusCode(), (Object)HttpStatus.FORBIDDEN)) {
            return Mono.empty();
        }
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!adapter.supports(handler)) continue;
                Mono<HandlerResult> resultMono = adapter.handle(exchange2, handler);
                return this.handleResultMono(exchange2, resultMono);
            }
        }
        return Mono.error((Throwable)new IllegalStateException("No HandlerAdapter: " + handler));
    }

    public Mono<Void> handlePreFlight(ServerWebExchange exchange2) {
        return Flux.fromIterable(this.handlerMappings != null ? this.handlerMappings : Collections.emptyList()).concatMap(mapping -> mapping.getHandler(exchange2)).switchIfEmpty((Publisher)Mono.fromRunnable(() -> exchange2.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN))).next().then();
    }
}

