/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"instrument_name", "instrument_type", "unit", "meter_name", "meter_version", "meter_schema_url"})
public class SelectorModel {
    @Nullable
    @JsonProperty(value="instrument_name")
    private String instrumentName;
    @Nullable
    @JsonProperty(value="instrument_type")
    private InstrumentType instrumentType;
    @Nullable
    @JsonProperty(value="unit")
    private String unit;
    @Nullable
    @JsonProperty(value="meter_name")
    private String meterName;
    @Nullable
    @JsonProperty(value="meter_version")
    private String meterVersion;
    @Nullable
    @JsonProperty(value="meter_schema_url")
    private String meterSchemaUrl;

    @JsonProperty(value="instrument_name")
    @Nullable
    public String getInstrumentName() {
        return this.instrumentName;
    }

    public SelectorModel withInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
        return this;
    }

    @JsonProperty(value="instrument_type")
    public InstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    public SelectorModel withInstrumentType(InstrumentType instrumentType) {
        this.instrumentType = instrumentType;
        return this;
    }

    @JsonProperty(value="unit")
    @Nullable
    public String getUnit() {
        return this.unit;
    }

    public SelectorModel withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @JsonProperty(value="meter_name")
    @Nullable
    public String getMeterName() {
        return this.meterName;
    }

    public SelectorModel withMeterName(String meterName) {
        this.meterName = meterName;
        return this;
    }

    @JsonProperty(value="meter_version")
    @Nullable
    public String getMeterVersion() {
        return this.meterVersion;
    }

    public SelectorModel withMeterVersion(String meterVersion) {
        this.meterVersion = meterVersion;
        return this;
    }

    @JsonProperty(value="meter_schema_url")
    @Nullable
    public String getMeterSchemaUrl() {
        return this.meterSchemaUrl;
    }

    public SelectorModel withMeterSchemaUrl(String meterSchemaUrl) {
        this.meterSchemaUrl = meterSchemaUrl;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SelectorModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("instrumentName");
        sb.append('=');
        sb.append(this.instrumentName == null ? "<null>" : this.instrumentName);
        sb.append(',');
        sb.append("instrumentType");
        sb.append('=');
        sb.append(this.instrumentType == null ? "<null>" : this.instrumentType);
        sb.append(',');
        sb.append("unit");
        sb.append('=');
        sb.append(this.unit == null ? "<null>" : this.unit);
        sb.append(',');
        sb.append("meterName");
        sb.append('=');
        sb.append(this.meterName == null ? "<null>" : this.meterName);
        sb.append(',');
        sb.append("meterVersion");
        sb.append('=');
        sb.append(this.meterVersion == null ? "<null>" : this.meterVersion);
        sb.append(',');
        sb.append("meterSchemaUrl");
        sb.append('=');
        sb.append(this.meterSchemaUrl == null ? "<null>" : this.meterSchemaUrl);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.instrumentName == null ? 0 : this.instrumentName.hashCode());
        result = result * 31 + (this.instrumentType == null ? 0 : this.instrumentType.hashCode());
        result = result * 31 + (this.unit == null ? 0 : this.unit.hashCode());
        result = result * 31 + (this.meterSchemaUrl == null ? 0 : this.meterSchemaUrl.hashCode());
        result = result * 31 + (this.meterName == null ? 0 : this.meterName.hashCode());
        result = result * 31 + (this.meterVersion == null ? 0 : this.meterVersion.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SelectorModel)) {
            return false;
        }
        SelectorModel rhs = (SelectorModel)other;
        return (this.instrumentName == rhs.instrumentName || this.instrumentName != null && this.instrumentName.equals(rhs.instrumentName)) && (this.instrumentType == rhs.instrumentType || this.instrumentType != null && this.instrumentType.equals((Object)rhs.instrumentType)) && (this.unit == rhs.unit || this.unit != null && this.unit.equals(rhs.unit)) && (this.meterSchemaUrl == rhs.meterSchemaUrl || this.meterSchemaUrl != null && this.meterSchemaUrl.equals(rhs.meterSchemaUrl)) && (this.meterName == rhs.meterName || this.meterName != null && this.meterName.equals(rhs.meterName)) && (this.meterVersion == rhs.meterVersion || this.meterVersion != null && this.meterVersion.equals(rhs.meterVersion));
    }

    public static enum InstrumentType {
        COUNTER("counter"),
        HISTOGRAM("histogram"),
        OBSERVABLE_COUNTER("observable_counter"),
        OBSERVABLE_GAUGE("observable_gauge"),
        OBSERVABLE_UP_DOWN_COUNTER("observable_up_down_counter"),
        UP_DOWN_COUNTER("up_down_counter");

        private final String value;
        private static final Map<String, InstrumentType> CONSTANTS;

        private InstrumentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static InstrumentType fromValue(String value) {
            InstrumentType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, InstrumentType>();
            for (InstrumentType c : InstrumentType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

