/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.view;

import cn.afterturn.easypoi.view.EasypoiBigExcelExportView;
import cn.afterturn.easypoi.view.EasypoiMapExcelView;
import cn.afterturn.easypoi.view.EasypoiSingleExcelView;
import cn.afterturn.easypoi.view.EasypoiTemplateExcelView;
import cn.afterturn.easypoi.view.MapGraphExcelView;
import cn.afterturn.easypoi.view.MiniAbstractExcelView;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;

public abstract class PoiBaseView
extends AbstractView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiBaseView.class);

    protected static boolean isIE(HttpServletRequest request) {
        return request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("rv:11.0") > 0 || request.getHeader("USER-AGENT").toLowerCase().indexOf("edge") > 0;
    }

    public static void render(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response, String viewName) {
        MiniAbstractExcelView view = null;
        if ("easypoiBigExcelView".equals(viewName)) {
            view = new EasypoiBigExcelExportView();
        } else if ("easypoiMapExcelView".equals(viewName)) {
            view = new EasypoiMapExcelView();
        } else if ("easypoiExcelView".equals(viewName)) {
            view = new EasypoiSingleExcelView();
        } else if ("easypoiTemplateExcelView".equals(viewName)) {
            view = new EasypoiTemplateExcelView();
        } else if ("MapGraphExcelView".equals(viewName)) {
            view = new MapGraphExcelView();
        }
        try {
            view.renderMergedOutputModel(model, request, response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

