/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hertzbeat.alert.dto.AlertDefineDTO;
import org.apache.hertzbeat.alert.dto.ExportAlertDefineDTO;
import org.apache.hertzbeat.alert.service.impl.AlertDefineAbstractImExportServiceImpl;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AlertDefineExcelImExportServiceImpl
extends AlertDefineAbstractImExportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineExcelImExportServiceImpl.class);

    @Override
    public String type() {
        return "EXCEL";
    }

    @Override
    public String getFileName() {
        return this.fileNamePrefix() + ".xlsx";
    }

    @Override
    public List<ExportAlertDefineDTO> parseImport(InputStream is) {
        ArrayList<ExportAlertDefineDTO> arrayList;
        block9: {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            try {
                Sheet sheet = workbook.getSheetAt(0);
                ArrayList<ExportAlertDefineDTO> alertDefines = new ArrayList<ExportAlertDefineDTO>();
                for (Row row : sheet) {
                    String app;
                    if (row.getRowNum() == 0 || !StringUtils.hasText((String)(app = this.getCellValueAsString(row.getCell(0))))) continue;
                    AlertDefineDTO alertDefineDTO = this.extractAlertDefineDataFromRow(row);
                    ExportAlertDefineDTO exportAlertDefineDTO = new ExportAlertDefineDTO();
                    exportAlertDefineDTO.setAlertDefine(alertDefineDTO);
                    alertDefines.add(exportAlertDefineDTO);
                }
                arrayList = alertDefines;
                if (workbook == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse alertDefine data", e);
                }
            }
            workbook.close();
        }
        return arrayList;
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return null;
        }
        return switch (cell.getCellType()) {
            case CellType.STRING -> cell.getStringCellValue();
            case CellType.NUMERIC -> String.valueOf(cell.getNumericCellValue());
            default -> null;
        };
    }

    private boolean getCellValueAsBoolean(Cell cell) {
        if (cell == null) {
            return false;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        return false;
    }

    private Integer getCellValueAsInteger(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (int)cell.getNumericCellValue();
        }
        return null;
    }

    private Byte getCellValueAsByte(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (Objects.requireNonNull(cell.getCellType()) == CellType.NUMERIC) {
            return (byte)cell.getNumericCellValue();
        }
        return null;
    }

    private AlertDefineDTO extractAlertDefineDataFromRow(Row row) {
        TypeReference<Map<String, String>> typeReference = new TypeReference<Map<String, String>>(){};
        AlertDefineDTO alertDefineDTO = new AlertDefineDTO();
        alertDefineDTO.setName(this.getCellValueAsString(row.getCell(0)));
        alertDefineDTO.setType(this.getCellValueAsString(row.getCell(1)));
        alertDefineDTO.setExpr(this.getCellValueAsString(row.getCell(2)));
        alertDefineDTO.setPeriod(this.getCellValueAsInteger(row.getCell(3)));
        alertDefineDTO.setTimes(this.getCellValueAsInteger(row.getCell(4)));
        alertDefineDTO.setLabels((Map)JsonUtil.fromJson((String)this.getCellValueAsString(row.getCell(5)), (TypeReference)typeReference));
        alertDefineDTO.setAnnotations((Map)JsonUtil.fromJson((String)this.getCellValueAsString(row.getCell(6)), (TypeReference)typeReference));
        alertDefineDTO.setTemplate(this.getCellValueAsString(row.getCell(7)));
        alertDefineDTO.setEnable(this.getCellValueAsBoolean(row.getCell(8)));
        return alertDefineDTO;
    }

    @Override
    public void writeOs(List<ExportAlertDefineDTO> exportAlertDefineList, OutputStream os) {
        try {
            Workbook workbook = WorkbookFactory.create((boolean)true);
            String sheetName = "Export AlertDefine";
            Sheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultColumnWidth(20);
            sheet.setColumnWidth(2, 10240);
            sheet.setColumnWidth(5, 10240);
            sheet.setColumnWidth(6, 10240);
            sheet.setColumnWidth(7, 10240);
            CellStyle headerCellStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerCellStyle.setFont(headerFont);
            headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            String[] headers = new String[]{"Name", "Type", "Expr", "Period", "Times", "Labels", "Annotations", "Template", "Enable"};
            Row headerRow = sheet.createRow(0);
            for (int i = 0; i < headers.length; ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(headers[i]);
                cell.setCellStyle(headerCellStyle);
            }
            int rowIndex = 1;
            for (ExportAlertDefineDTO alertDefine : exportAlertDefineList) {
                AlertDefineDTO alertDefineDTO = alertDefine.getAlertDefine();
                Row row = sheet.createRow(rowIndex++);
                Cell nameCell = row.createCell(0);
                nameCell.setCellValue(alertDefineDTO.getName());
                nameCell.setCellStyle(cellStyle);
                Cell typeCell = row.createCell(1);
                typeCell.setCellValue(alertDefineDTO.getType());
                typeCell.setCellStyle(cellStyle);
                Cell exprCell = row.createCell(2);
                exprCell.setCellValue(alertDefineDTO.getExpr());
                exprCell.setCellStyle(cellStyle);
                Cell periodCell = row.createCell(3);
                periodCell.setCellValue((double)alertDefineDTO.getPeriod().intValue());
                periodCell.setCellStyle(cellStyle);
                Cell timesCell = row.createCell(4);
                timesCell.setCellValue((double)alertDefineDTO.getTimes().intValue());
                timesCell.setCellStyle(cellStyle);
                Cell labelsCell = row.createCell(5);
                labelsCell.setCellValue(JsonUtil.toJson(alertDefineDTO.getLabels()));
                labelsCell.setCellStyle(cellStyle);
                Cell annoCell = row.createCell(6);
                annoCell.setCellValue(JsonUtil.toJson(alertDefineDTO.getAnnotations()));
                annoCell.setCellStyle(cellStyle);
                Cell templateCell = row.createCell(7);
                templateCell.setCellValue(alertDefineDTO.getTemplate());
                templateCell.setCellStyle(cellStyle);
                Cell enableCell = row.createCell(8);
                enableCell.setCellValue(alertDefineDTO.getEnable().booleanValue());
                enableCell.setCellStyle(cellStyle);
            }
            workbook.write(os);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

