/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.DefaultBHttpServerConnection;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicResponseBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class ClassicResponseBuilderTest {
    @Mock
    Socket socket;
    DefaultBHttpServerConnection conn;
    ByteArrayOutputStream outStream;

    ClassicResponseBuilderTest() {
    }

    @BeforeEach
    void prepareMocks() throws IOException {
        MockitoAnnotations.openMocks((Object)this);
        this.conn = new DefaultBHttpServerConnection("http", Http1Config.DEFAULT, null, null, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (HttpMessageParserFactory)DefaultHttpRequestParserFactory.INSTANCE, (HttpMessageWriterFactory)DefaultHttpResponseWriterFactory.INSTANCE);
        this.outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)this.outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
    }

    @Test
    void create() throws IOException, HttpException {
        ClassicHttpResponse response = ClassicResponseBuilder.create((int)200).setHeader("X-Test-Filter", "active").addHeader("header1", "blah").setHeader((Header)new BasicHeader("header2", (Object)"blah")).addHeader((Header)new BasicHeader("header3", (Object)"blah")).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setEntity("<html><body><h1>Access OK</h1></body></html>", ContentType.TEXT_HTML).setEntity("Another entity").build();
        response.addHeader("User-Agent", (Object)"test");
        this.conn.sendResponseHeader(response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(this.outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nX-Test-Filter: active\r\nheader1: blah\r\nheader2: blah\r\nheader3: blah\r\nUser-Agent: test\r\n\r\n", (Object)s);
        Assertions.assertNotNull((Object)response.getEntity());
    }

    @Test
    void remove() throws IOException, HttpException {
        BasicHeader header = new BasicHeader("header2", (Object)"blah");
        ClassicHttpResponse response = ClassicResponseBuilder.create((int)200).setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN)).setHeader("X-Test-Filter", "active").addHeader("header1", "blah").setHeader((Header)header).addHeader((Header)new BasicHeader("header3", (Object)"blah")).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setEntity("<html><body><h1>Access OK</h1></body></html>", ContentType.TEXT_HTML).setEntity("Another entity").removeHeader((Header)header).build();
        response.removeHeaders("X-Test-Filter");
        this.conn.sendResponseHeader(response);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(this.outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nheader1: blah\r\nheader3: blah\r\n\r\n", (Object)s);
        Assertions.assertNotNull((Object)response.getEntity());
    }

    @Test
    void copy() throws IOException, HttpException {
        BasicHeader header = new BasicHeader("header2", (Object)"blah");
        ClassicHttpResponse response = ClassicResponseBuilder.create((int)200).setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN)).addHeader("header1", "blah").setHeader((Header)header).addHeader((Header)new BasicHeader("header3", (Object)"blah")).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1).setEntity("<html><body><h1>Access OK</h1></body></html>", ContentType.TEXT_HTML).setEntity("Another entity").removeHeader((Header)header).build();
        ClassicResponseBuilder classicResponseBuilder = ClassicResponseBuilder.copy((ClassicHttpResponse)response);
        ClassicHttpResponse response2 = classicResponseBuilder.build();
        this.conn.sendResponseHeader(response2);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        String s = new String(this.outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"HTTP/1.1 200 OK\r\nheader1: blah\r\nheader3: blah\r\n\r\n", (Object)s);
        Assertions.assertNotNull((Object)response.getEntity());
        Assertions.assertNotNull((Object)classicResponseBuilder.toString());
    }
}

