/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mem;

import java.io.Serializable;
import org.apache.ignite.internal.mem.NumaAllocUtil;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.mem.NumaAllocationStrategy;

public class SimpleNumaAllocationStrategy
implements NumaAllocationStrategy,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int NODE_NOT_SET = Integer.MAX_VALUE;
    @GridToStringInclude
    private final int node;

    public SimpleNumaAllocationStrategy() {
        this.node = Integer.MAX_VALUE;
    }

    public SimpleNumaAllocationStrategy(int node) {
        A.ensure((node >= 0 ? 1 : 0) != 0, (String)("NUMA node number must be positive, passed instead " + node));
        A.ensure((node < NumaAllocUtil.NUMA_NODES_CNT ? 1 : 0) != 0, (String)("NUMA node number must be less than NUMA_NODES_CNT=" + NumaAllocUtil.NUMA_NODES_CNT + ", passed instead " + node));
        this.node = node;
    }

    @Override
    public long allocateMemory(long size) {
        if (this.node == Integer.MAX_VALUE) {
            return NumaAllocUtil.allocate(size);
        }
        return NumaAllocUtil.allocateOnNode(size, this.node);
    }

    public String toString() {
        return GridToStringBuilder.toString(SimpleNumaAllocationStrategy.class, (Object)this);
    }
}

