/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanCacheStoresMaintenanceAction
implements MaintenanceAction<Void> {
    public static final String ACTION_NAME = "clean_data_files";
    private final File rootStoreDir;
    private final String[] cacheStoreDirs;

    public CleanCacheStoresMaintenanceAction(File rootStoreDir, String[] cacheStoreDirs) {
        this.rootStoreDir = rootStoreDir;
        this.cacheStoreDirs = cacheStoreDirs;
    }

    @Override
    public Void execute() {
        for (String cacheStoreDirName : this.cacheStoreDirs) {
            File cacheStoreDir = new File(this.rootStoreDir, cacheStoreDirName);
            if (!cacheStoreDir.exists() || !cacheStoreDir.isDirectory()) continue;
            for (File file : cacheStoreDir.listFiles()) {
                if (file.getName().equals("cache_data.dat")) continue;
                file.delete();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String name() {
        return ACTION_NAME;
    }

    @Override
    @Nullable
    public String description() {
        return "Cleans data files of cache groups";
    }
}

