/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.timeout;

import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public abstract class GridTimeoutObjectAdapter
implements GridTimeoutObject {
    private final IgniteUuid id;
    private final long endTime;

    protected GridTimeoutObjectAdapter(long timeout) {
        this(IgniteUuid.randomUuid(), timeout);
    }

    protected GridTimeoutObjectAdapter(IgniteUuid id, long timeout) {
        this.id = id;
        long endTime = timeout >= 0L ? U.currentTimeMillis() + timeout : Long.MAX_VALUE;
        this.endTime = endTime >= 0L ? endTime : Long.MAX_VALUE;
    }

    @Override
    public IgniteUuid timeoutId() {
        return this.id;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }
}

