/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.NodeOrderLegacyComparator;

public class NodeOrderComparator
implements Comparator<ClusterNode>,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final Comparator<ClusterNode> INSTANCE = new NodeOrderComparator();

    public static Comparator<ClusterNode> getInstance() {
        return IgniteSystemProperties.getBoolean("IGNITE_USE_LEGACY_NODE_COMPARATOR") ? NodeOrderLegacyComparator.INSTANCE : INSTANCE;
    }

    private NodeOrderComparator() {
    }

    @Override
    public int compare(ClusterNode n1, ClusterNode n2) {
        Object id1 = n1.consistentId();
        Object id2 = n2.consistentId();
        if (id1 instanceof Comparable && id2 instanceof Comparable && id1.getClass().equals(id2.getClass())) {
            return ((Comparable)id1).compareTo(id2);
        }
        return id1.toString().compareTo(id2.toString());
    }
}

