/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheLockTimeoutException;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockCancelledException;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtEmbeddedFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFinishedFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtUnlockRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtForceKeysResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearSingleGetRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTransactionalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearUnlockRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTransactionalCacheAdapter<K, V>
extends GridDhtCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;

    protected GridDhtTransactionalCacheAdapter() {
    }

    protected GridDhtTransactionalCacheAdapter(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    protected GridDhtTransactionalCacheAdapter(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        super.onKernalStart();
        assert (!this.ctx.isRecoveryMode()) : "Registering message handlers in recovery mode [cacheName=" + this.name() + "]";
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridNearGetRequest.class, this::processNearGetRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridNearSingleGetRequest.class, this::processNearSingleGetRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridNearLockRequest.class, this::processNearLockRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridDhtLockRequest.class, this::processDhtLockRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridDhtLockResponse.class, this::processDhtLockResponse);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridNearUnlockRequest.class, this::processNearUnlockRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridDhtUnlockRequest.class, this::processDhtUnlockRequest);
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridDhtForceKeysRequest.class, new GridDhtCacheAdapter.MessageHandler<GridDhtForceKeysRequest>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtForceKeysRequest msg) {
                GridDhtTransactionalCacheAdapter.this.processForceKeysRequest(node, msg);
            }
        });
        this.ctx.io().addCacheHandler(this.ctx.cacheId(), this.ctx.startTopologyVersion(), GridDhtForceKeysResponse.class, new GridDhtCacheAdapter.MessageHandler<GridDhtForceKeysResponse>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtForceKeysResponse msg) {
                GridDhtTransactionalCacheAdapter.this.processForceKeyResponse(node, msg);
            }
        });
    }

    @Override
    public abstract GridNearTransactionalCache<K, V> near();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private GridDhtTxRemote startRemoteTx(UUID nodeId, GridDhtLockRequest req, GridDhtLockResponse res) throws IgniteCheckedException, GridDistributedLockCancelledException {
        List<KeyCacheObject> keys = req.keys();
        GridDistributedTxRemoteAdapter tx = null;
        int size = F.size(keys, new IgnitePredicate[0]);
        int i = 0;
        while (true) {
            block29: {
                IgniteTxKey txKey;
                KeyCacheObject key;
                block30: {
                    block28: {
                        if (i >= size) break block28;
                        key = keys.get(i);
                        if (key == null) break block29;
                        txKey = this.ctx.txKey(key);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Unmarshalled key: " + key);
                        }
                        break block30;
                    }
                    if (tx == null) return tx;
                    if (!tx.empty()) return tx;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Rolling back remote DHT transaction because it is empty [req=" + req + ", res=" + res + "]");
                    }
                    tx.rollbackRemoteTx();
                    return null;
                }
                GridCacheMapEntry entry = null;
                while (true) {
                    try {
                        int part = this.ctx.affinity().partition(key);
                        GridDhtLocalPartition locPart = this.ctx.topology().localPartition(part, req.topologyVersion(), false);
                        if (locPart == null || !locPart.reserve()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Local partition for given key is already evicted (will add to invalid partition list) [key=" + key + ", part=" + part + ", locPart=" + locPart + "]");
                            }
                            res.addInvalidPartition(part);
                            if (!GridCacheUtils.isNearEnabled(this.cacheCfg)) break;
                            this.obsoleteNearEntry(key);
                            break;
                        }
                        try {
                            if (req.inTx()) {
                                if (tx == null) {
                                    tx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
                                }
                                if (tx == null) {
                                    tx = new GridDhtTxRemote(this.ctx.shared(), req.nodeId(), nodeId, req.nearXidVersion(), req.topologyVersion(), req.version(), null, this.ctx.systemTx(), this.ctx.ioPolicy(), TransactionConcurrency.PESSIMISTIC, req.isolation(), req.isInvalidate(), req.timeout(), req.txSize(), SecurityUtils.securitySubjectId(this.ctx), req.taskNameHash(), !req.skipStore() && req.storeUsed(), req.txLabel());
                                    tx = (GridDhtTxRemote)this.ctx.tm().onCreated(null, tx);
                                    if (tx == null) throw new IgniteTxRollbackCheckedException("Failed to acquire lock (transaction has been completed) [ver=" + req.version() + ", tx=" + (GridDhtTxRemote)tx + "]");
                                    if (!this.ctx.tm().onStarted(tx)) {
                                        throw new IgniteTxRollbackCheckedException("Failed to acquire lock (transaction has been completed) [ver=" + req.version() + ", tx=" + (GridDhtTxRemote)tx + "]");
                                    }
                                }
                                ((GridDhtTxRemote)tx).addWrite(this.ctx, GridCacheOperation.NOOP, txKey, null, null, req.accessTtl(), req.skipStore(), req.keepBinary());
                            }
                            entry = this.entryExx(key, req.topologyVersion());
                            ((GridDistributedCacheEntry)entry).addRemote(req.nodeId(), nodeId, req.threadId(), req.version(), tx != null, tx != null && tx.implicitSingle(), null);
                            if (GridCacheUtils.isNearEnabled(this.cacheCfg) && req.invalidateNearEntry(i)) {
                                this.invalidateNearEntry(key, req.version());
                            }
                            if (req.needPreloadKey(i)) {
                                entry.unswap();
                                GridCacheEntryInfo info = entry.info();
                                if (info != null && !info.isNew() && !info.isDeleted()) {
                                    res.addPreloadEntry(info);
                                }
                            }
                            if (this.ctx.discovery().node(req.nodeId()) == null) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Node requesting lock left grid (lock request will be ignored): " + req);
                                }
                                ((GridDistributedCacheEntry)entry).removeLock(req.version());
                                if (tx != null) {
                                    tx.clearEntry(txKey);
                                    if (tx.state() == TransactionState.COMMITTING) {
                                        tx.forceCommit();
                                    } else {
                                        tx.rollbackRemoteTx();
                                    }
                                }
                                GridDhtTxRemote gridDhtTxRemote = null;
                                return gridDhtTxRemote;
                            }
                        }
                        finally {
                            locPart.release();
                        }
                    }
                    catch (GridDhtInvalidPartitionException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received invalid partition exception [e=" + e + ", req=" + req + "]");
                        }
                        res.addInvalidPartition(e.partition());
                        if (GridCacheUtils.isNearEnabled(this.cacheCfg)) {
                            this.obsoleteNearEntry(key);
                        }
                        if (tx == null) break;
                        tx.clearEntry(txKey);
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("Cleared invalid entry from remote transaction (will skip) [entry=" + (GridDistributedCacheEntry)entry + ", tx=" + (GridDhtTxRemote)tx + "]");
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        assert (entry.obsoleteVersion() != null) : "Obsolete flag not set on removed entry: " + (GridDistributedCacheEntry)entry;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Received entry removed exception (will retry on renewed entry): " + (GridDistributedCacheEntry)entry);
                        }
                        if (tx == null) continue;
                        tx.clearEntry(txKey);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Cleared removed entry from remote transaction (will retry) [entry=" + (GridDistributedCacheEntry)entry + ", tx=" + (GridDhtTxRemote)tx + "]");
                        continue;
                    }
                    break;
                }
            }
            ++i;
        }
    }

    private void processDhtLockRequest(final UUID nodeId, final GridDhtLockRequest req) {
        GridDhtFuture<Object> keyFut;
        if (this.txLockMsgLog.isDebugEnabled()) {
            this.txLockMsgLog.debug("Received dht lock request [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]");
        }
        GridDhtFuture<Object> gridDhtFuture = keyFut = F.isEmpty(req.keys()) ? null : this.ctx.group().preloader().request(this.ctx, req.keys(), req.topologyVersion());
        if (keyFut == null || keyFut.isDone()) {
            if (keyFut != null) {
                try {
                    keyFut.get();
                }
                catch (NodeStoppingException ignored) {
                    return;
                }
                catch (IgniteCheckedException e) {
                    this.onForceKeysError(nodeId, req, e);
                    return;
                }
            }
            this.processDhtLockRequest0(nodeId, req);
        } else {
            keyFut.listen(new CI1<IgniteInternalFuture<Object>>(){

                @Override
                public void apply(IgniteInternalFuture<Object> fut) {
                    try {
                        fut.get();
                    }
                    catch (NodeStoppingException ignored) {
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        GridDhtTransactionalCacheAdapter.this.onForceKeysError(nodeId, req, e);
                        return;
                    }
                    GridDhtTransactionalCacheAdapter.this.processDhtLockRequest0(nodeId, req);
                }
            });
        }
    }

    private void onForceKeysError(UUID nodeId, GridDhtLockRequest req, IgniteCheckedException e) {
        GridDhtLockResponse res = new GridDhtLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), (Throwable)e, this.ctx.deploymentEnabled());
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, this.ctx.ioPolicy());
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send lock reply to remote node because it left grid: " + nodeId);
            }
        }
        catch (IgniteCheckedException ignored) {
            U.error(this.log, "Failed to send lock reply to node: " + nodeId, e);
        }
    }

    private void processDhtLockRequest0(UUID nodeId, GridDhtLockRequest req) {
        String err;
        GridDhtLockResponse res;
        assert (nodeId != null);
        assert (req != null);
        assert (!nodeId.equals(this.locNodeId));
        int cnt = F.size(req.keys(), new IgnitePredicate[0]);
        GridDistributedTxRemoteAdapter dhtTx = null;
        boolean fail = false;
        boolean cancelled = false;
        try {
            res = new GridDhtLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), cnt, this.ctx.deploymentEnabled());
            dhtTx = this.startRemoteTx(nodeId, req, res);
        }
        catch (IgniteTxRollbackCheckedException e) {
            err = "Failed processing DHT lock request (transaction has been completed): " + req;
            U.error(this.log, err, e);
            res = new GridDhtLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), (Throwable)new IgniteTxRollbackCheckedException(err, e), this.ctx.deploymentEnabled());
            fail = true;
        }
        catch (IgniteCheckedException e) {
            err = "Failed processing DHT lock request: " + req;
            U.error(this.log, err, e);
            res = new GridDhtLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), (Throwable)new IgniteCheckedException(err, e), this.ctx.deploymentEnabled());
            fail = true;
        }
        catch (GridDistributedLockCancelledException ignored) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received lock request for canceled lock (will ignore): " + req);
            }
            res = null;
            fail = true;
            cancelled = true;
        }
        boolean releaseAll = false;
        if (res != null) {
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, this.ctx.ioPolicy());
                if (this.txLockMsgLog.isDebugEnabled()) {
                    this.txLockMsgLog.debug("Sent dht lock response [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]");
                }
            }
            catch (ClusterTopologyCheckedException ignored) {
                U.warn(this.txLockMsgLog, "Failed to send dht lock response, node failed [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]");
                fail = true;
                releaseAll = true;
            }
            catch (IgniteCheckedException e) {
                U.error(this.txLockMsgLog, "Failed to send dht lock response (lock will not be acquired) txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]", e);
                fail = true;
            }
        }
        if (fail) {
            List<KeyCacheObject> keys;
            if (dhtTx != null) {
                dhtTx.rollbackRemoteTx();
            }
            if ((keys = req.keys()) != null) {
                block9: for (KeyCacheObject key : keys) {
                    while (true) {
                        GridDhtCacheEntry entry = this.peekExx(key);
                        try {
                            if (entry == null) continue block9;
                            if (releaseAll) {
                                entry.removeExplicitNodeLocks(req.nodeId());
                                continue block9;
                            }
                            ((GridDistributedCacheEntry)entry).removeLock(req.version());
                            continue block9;
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Attempted to remove lock on removed entity during during failure handling for dht lock request (will retry): " + entry);
                            continue;
                        }
                        break;
                    }
                }
            }
            if (releaseAll && !cancelled) {
                U.warn(this.log, "Sender node left grid in the midst of lock acquisition (locks have been released).");
            }
        }
    }

    private void processDhtUnlockRequest(UUID nodeId, GridDhtUnlockRequest req) {
        this.clearLocks(nodeId, req);
        if (GridCacheUtils.isNearEnabled(this.cacheCfg)) {
            ((GridNearTransactionalCache)this.near()).clearLocks(nodeId, req);
        }
    }

    private void processNearLockRequest(UUID nodeId, GridNearLockRequest req) {
        ClusterNode nearNode;
        assert (this.ctx.affinityNode());
        assert (nodeId != null);
        assert (req != null);
        if (this.txLockMsgLog.isDebugEnabled()) {
            this.txLockMsgLog.debug("Received near lock request [txId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]");
        }
        if ((nearNode = this.ctx.discovery().node(nodeId)) == null) {
            U.warn(this.txLockMsgLog, "Received near lock request from unknown node (will ignore) [txId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nodeId + "]");
            return;
        }
        this.processNearLockRequest0(nearNode, req);
    }

    private void processNearLockRequest0(ClusterNode nearNode, GridNearLockRequest req) {
        IgniteInternalFuture<GridNearLockResponse> f;
        if (req.firstClientRequest()) {
            do {
                if (!this.waitForExchangeFuture(nearNode, req)) continue;
                return;
            } while ((f = this.lockAllAsync(this.ctx, nearNode, req)) == null);
        } else {
            f = this.lockAllAsync(this.ctx, nearNode, req);
        }
        f.listen(CU.errorLogger(this.log, GridCacheLockTimeoutException.class, GridDistributedLockCancelledException.class, IgniteTxTimeoutCheckedException.class, IgniteTxRollbackCheckedException.class));
    }

    private boolean waitForExchangeFuture(final ClusterNode node, final GridNearLockRequest req) {
        assert (req.firstClientRequest()) : req;
        GridDhtPartitionsExchangeFuture topFut = this.ctx.shared().exchange().lastTopologyFuture();
        if (!topFut.isDone()) {
            IgniteThread thread;
            Thread curThread = Thread.currentThread();
            if (curThread instanceof IgniteThread && (thread = (IgniteThread)curThread).cachePoolThread()) {
                topFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        GridDhtTransactionalCacheAdapter.this.ctx.kernalContext().closure().runLocalWithThreadPolicy(thread, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GridDhtTransactionalCacheAdapter.this.processNearLockRequest0(node, req);
                                }
                                finally {
                                    GridDhtTransactionalCacheAdapter.this.ctx.io().onMessageProcessed(req);
                                }
                            }
                        });
                    }
                });
                return true;
            }
            try {
                topFut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Topology future failed: " + e, e);
            }
        }
        return false;
    }

    private void processDhtLockResponse(UUID nodeId, GridDhtLockResponse res) {
        assert (nodeId != null);
        assert (res != null);
        GridDhtLockFuture fut = (GridDhtLockFuture)this.ctx.mvcc().versionedFuture(res.version(), res.futureId());
        if (fut == null) {
            if (this.txLockMsgLog.isDebugEnabled()) {
                this.txLockMsgLog.debug("Received dht lock response for unknown future [txId=null, dhtTxId=" + res.version() + ", node=" + nodeId + "]");
            }
            return;
        }
        if (this.txLockMsgLog.isDebugEnabled()) {
            this.txLockMsgLog.debug("Received dht lock response [txId=" + fut.nearLockVersion() + ", dhtTxId=" + res.version() + ", node=" + nodeId + "]");
        }
        fut.onResult(nodeId, res);
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx txx, boolean isInvalidate, boolean isRead, boolean retval, TransactionIsolation isolation, long createTtl, long accessTtl) {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return this.lockAllAsyncInternal(keys, timeout, txx, isInvalidate, isRead, retval, isolation, createTtl, accessTtl, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary());
    }

    public GridDhtFuture<Boolean> lockAllAsyncInternal(@Nullable Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx txx, boolean isInvalidate, boolean isRead, boolean retval, TransactionIsolation isolation, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary) {
        if (keys == null || keys.isEmpty()) {
            return new GridDhtFinishedFuture<Boolean>(true);
        }
        GridDhtTxLocalAdapter tx = (GridDhtTxLocalAdapter)txx;
        assert (tx != null);
        GridDhtLockFuture fut = new GridDhtLockFuture(this.ctx, tx.nearNodeId(), tx.nearXidVersion(), tx.topologyVersion(), keys.size(), isRead, retval, timeout, tx, tx.threadId(), createTtl, accessTtl, skipStore, keepBinary);
        if (fut.isDone()) {
            return fut;
        }
        block5: for (KeyCacheObject key : keys) {
            try {
                while (true) {
                    GridDhtCacheEntry entry = this.entryExx(key, tx.topologyVersion());
                    try {
                        fut.addEntry(entry);
                        if (!fut.isDone()) continue block5;
                        return fut;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Got removed entry when adding lock (will retry): " + entry);
                        continue;
                    }
                    catch (GridDistributedLockCancelledException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to add entry [err=" + e + ", entry=" + entry + "]");
                        }
                        return new GridDhtFinishedFuture<Boolean>(e);
                    }
                    break;
                }
            }
            catch (GridDhtInvalidPartitionException e) {
                fut.addInvalidPartition(this.ctx, e.partition());
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Added invalid partition to DHT lock future [part=" + e.partition() + ", fut=" + fut + "]");
            }
        }
        if (!fut.isDone()) {
            this.ctx.mvcc().addFuture(fut);
            fut.map();
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public IgniteInternalFuture<GridNearLockResponse> lockAllAsync(GridCacheContext<?, ?> cacheCtx, final ClusterNode nearNode, final GridNearLockRequest req) {
        List<KeyCacheObject> keys = req.keys();
        GridDhtTxLocal tx = null;
        try {
            GridCacheVersion dhtVer;
            int cnt = keys.size();
            if (req.inTx() && (dhtVer = this.ctx.tm().mappedVersion(req.version())) != null) {
                tx = (GridDhtTxLocal)this.ctx.tm().tx(dhtVer);
            }
            final ArrayList<GridCacheEntryEx> entries = new ArrayList<GridCacheEntryEx>(cnt);
            GridDhtLockFuture fut = null;
            GridDhtPartitionTopology top = null;
            if (req.firstClientRequest()) {
                assert (nearNode.isClient());
                top = this.topology();
                top.readLock();
                if (!top.topologyVersionFuture().isDone()) {
                    top.readUnlock();
                    return null;
                }
            }
            try {
                if (top != null && this.needRemap(req.topologyVersion())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Client topology version mismatch, need remap lock request [reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.readyTopologyVersion() + ", req=" + req + "]");
                    }
                    GridNearLockResponse res = this.sendClientLockRemapResponse(nearNode, req, top.lastTopologyChangeVersion());
                    GridFinishedFuture<GridNearLockResponse> gridFinishedFuture = new GridFinishedFuture<GridNearLockResponse>(res);
                    return gridFinishedFuture;
                }
                if (req.inTx()) {
                    Object opCtx;
                    GridDhtPartitionsExchangeFuture lastFinishedFut;
                    CacheInvalidStateException validateCacheE;
                    if (tx == null) {
                        tx = new GridDhtTxLocal(this.ctx.shared(), this.topology().readyTopologyVersion(), nearNode.id(), req.version(), req.futureId(), req.miniId(), req.threadId(), false, false, this.ctx.systemTx(), false, this.ctx.ioPolicy(), TransactionConcurrency.PESSIMISTIC, req.isolation(), req.timeout(), req.isInvalidate(), !req.skipStore(), false, req.txSize(), null, SecurityUtils.securitySubjectId(this.ctx), req.taskNameHash(), req.txLabel(), null);
                        if (req.syncCommit()) {
                            tx.syncMode(CacheWriteSynchronizationMode.FULL_SYNC);
                        }
                        if ((tx = this.ctx.tm().onCreated(null, tx)) == null || !tx.init()) {
                            String msg = "Failed to acquire lock (transaction has been completed): " + req.version();
                            U.warn(this.log, msg);
                            if (tx != null) {
                                tx.rollbackDhtLocal();
                            }
                            GridDhtFinishedFuture<GridNearLockResponse> gridDhtFinishedFuture = new GridDhtFinishedFuture<GridNearLockResponse>(new IgniteTxRollbackCheckedException(msg));
                            return gridDhtFinishedFuture;
                        }
                        tx.topologyVersion(req.topologyVersion());
                    }
                    if ((validateCacheE = (lastFinishedFut = this.ctx.shared().exchange().lastFinishedFuture()).validateCache(this.ctx, (opCtx = this.ctx.operationContextPerCall()) != null && ((CacheOperationContext)opCtx).recovery(), req.txRead(), null, keys)) != null) {
                        throw validateCacheE;
                    }
                } else {
                    fut = new GridDhtLockFuture(this.ctx, nearNode.id(), req.version(), req.topologyVersion(), cnt, req.txRead(), req.needReturnValue(), req.timeout(), tx, req.threadId(), req.createTtl(), req.accessTtl(), req.skipStore(), req.keepBinary());
                    if (!this.ctx.mvcc().addFuture(fut)) {
                        throw new IllegalStateException("Duplicate future ID: " + fut);
                    }
                }
            }
            finally {
                if (top != null) {
                    top.readUnlock();
                }
            }
            boolean timedOut = false;
            block14: for (KeyCacheObject key : keys) {
                if (timedOut) break;
                while (true) {
                    GridDhtCacheEntry entry = this.entryExx(key, req.topologyVersion());
                    try {
                        if (fut != null) {
                            fut.addEntry(key == null ? null : entry);
                            if (fut.isDone()) {
                                timedOut = true;
                                continue block14;
                            }
                        }
                        entries.add(entry);
                        continue block14;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Got removed entry when adding lock (will retry): " + entry);
                        continue;
                    }
                    catch (GridDistributedLockCancelledException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Got lock request for cancelled lock (will ignore): " + entry);
                        }
                        fut.onError(e);
                        return new GridDhtFinishedFuture<GridNearLockResponse>(e);
                    }
                    break;
                }
            }
            if (req.inTx()) {
                this.ctx.tm().txContext(tx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Performing DHT lock [tx=" + tx + ", entries=" + entries + "]");
                }
                IgniteInternalFuture<GridCacheReturn> txFut = tx.lockAllAsync(cacheCtx, entries, req.messageId(), req.txRead(), req.needReturnValue(), req.createTtl(), req.accessTtl(), req.skipStore(), req.keepBinary(), req.nearCache());
                final GridDhtTxLocal t = tx;
                return new GridDhtEmbeddedFuture<GridNearLockResponse, GridCacheReturn>(txFut, new C2<GridCacheReturn, Exception, IgniteInternalFuture<GridNearLockResponse>>(){

                    @Override
                    public IgniteInternalFuture<GridNearLockResponse> apply(GridCacheReturn o, Exception e) {
                        if (e != null) {
                            e = U.unwrap(e);
                        }
                        assert (e != null || !t.empty());
                        GridNearLockResponse resp = GridDhtTransactionalCacheAdapter.this.createLockReply(nearNode, entries, req, t, t.xidVersion(), e);
                        assert (!t.implicit()) : t;
                        assert (!t.onePhaseCommit()) : t;
                        GridDhtTransactionalCacheAdapter.this.sendLockReply(nearNode, t, req, resp);
                        return new GridFinishedFuture<GridNearLockResponse>(resp);
                    }
                });
            }
            assert (fut != null);
            fut.map();
            final GridCacheVersion mappedVer = fut.version();
            return new GridDhtEmbeddedFuture<GridNearLockResponse, Boolean>(new C2<Boolean, Exception, GridNearLockResponse>(){

                @Override
                public GridNearLockResponse apply(Boolean b, Exception e) {
                    if (e != null) {
                        e = U.unwrap(e);
                    } else if (!b.booleanValue()) {
                        e = new GridCacheLockTimeoutException(req.version());
                    }
                    GridNearLockResponse res = GridDhtTransactionalCacheAdapter.this.createLockReply(nearNode, entries, req, null, mappedVer, e);
                    GridDhtTransactionalCacheAdapter.this.sendLockReply(nearNode, null, req, res);
                    return res;
                }
            }, fut);
        }
        catch (RuntimeException | IgniteCheckedException e) {
            U.error(this.log, req, e);
            if (tx != null) {
                try {
                    tx.rollbackDhtLocal();
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Failed to rollback the transaction: " + tx, ex);
                }
            }
            try {
                GridNearLockResponse res = this.createLockReply(nearNode, Collections.emptyList(), req, tx, tx != null ? tx.xidVersion() : req.version(), e);
                this.sendLockReply(nearNode, null, req, res);
            }
            catch (Exception ex) {
                U.error(this.log, "Failed to send response for request message: " + req, ex);
            }
            return new GridDhtFinishedFuture<GridNearLockResponse>(new IgniteCheckedException(e));
        }
    }

    private GridNearLockResponse sendClientLockRemapResponse(ClusterNode nearNode, GridNearLockRequest req, AffinityTopologyVersion topVer) {
        assert (topVer != null);
        GridNearLockResponse res = new GridNearLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), false, 0, null, topVer, this.ctx.deploymentEnabled(), false);
        try {
            this.ctx.io().send(nearNode, (GridCacheMessage)res, this.ctx.ioPolicy());
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send client lock remap response, client node failed [node=" + nearNode + ", req=" + req + "]");
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send client lock remap response [node=" + nearNode + ", req=" + req + "]", e);
        }
        return res;
    }

    private GridNearLockResponse createLockReply(ClusterNode nearNode, List<GridCacheEntryEx> entries, GridNearLockRequest req, @Nullable GridDhtTxLocalAdapter tx, GridCacheVersion mappedVer, Throwable err) {
        assert (mappedVer != null);
        assert (tx == null || tx.xidVersion().equals(mappedVer));
        try {
            AffinityTopologyVersion clienRemapVer = req.firstClientRequest() && tx != null && this.topology().readyTopologyVersion().after(req.topologyVersion()) ? this.topology().readyTopologyVersion() : null;
            GridNearLockResponse res = new GridNearLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), tx != null && tx.onePhaseCommit(), entries.size(), err, clienRemapVer, this.ctx.deploymentEnabled(), clienRemapVer != null);
            if (err == null) {
                res.pending(this.localDhtPendingVersions(entries, mappedVer));
                IgnitePair<Collection<GridCacheVersion>> versPair = this.ctx.tm().versions(req.version());
                res.completedVersions((Collection)versPair.get1(), (Collection)versPair.get2());
                int i = 0;
                ListIterator<GridCacheEntryEx> it = entries.listIterator();
                while (it.hasNext()) {
                    GridCacheEntryEx e = it.next();
                    assert (e != null);
                    while (true) {
                        try {
                            if (tx == null || !tx.isRollbackOnly()) {
                                GridCacheVersion dhtVer = req.dhtVersion(i);
                                GridCacheVersion ver = e.version();
                                boolean ret = req.returnValue(i) || dhtVer == null || !dhtVer.equals(ver);
                                CacheObject val = null;
                                if (ret) {
                                    val = e.innerGet(null, tx, false, true, req.returnValue(i), null, tx != null ? tx.resolveTaskName() : null, null, req.keepBinary());
                                }
                                assert (e.lockedBy(mappedVer) || this.ctx.mvcc().isRemoved(e.context(), mappedVer) || tx != null && tx.isRollbackOnly()) : "Entry does not own lock for tx [locNodeId=" + this.ctx.localNodeId() + ", entry=" + e + ", mappedVer=" + mappedVer + ", ver=" + ver + ", tx=" + CU.txString(tx) + ", req=" + req + "]";
                                boolean filterPassed = false;
                                if (tx != null && tx.onePhaseCommit()) {
                                    IgniteTxEntry writeEntry = tx.entry(this.ctx.txKey(e.key()));
                                    assert (writeEntry != null) : "Missing tx entry for locked cache entry: " + e;
                                    filterPassed = writeEntry.filtersPassed();
                                }
                                if (ret && val == null) {
                                    val = e.valueBytes(null);
                                }
                                res.addValueBytes(ret ? val : null, filterPassed, ver, mappedVer);
                                break;
                            }
                            res.addValueBytes(null, false, e.version(), mappedVer);
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Got removed entry when sending reply to DHT lock request (will retry): " + e);
                            }
                            e = this.entryExx(e.key());
                            it.set(e);
                            continue;
                        }
                        break;
                    }
                    ++i;
                }
            }
            return res;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to get value for lock reply message for node [node=" + U.toShortString(nearNode) + ", req=" + req + "]", e);
            return new GridNearLockResponse(this.ctx.cacheId(), req.version(), req.futureId(), req.miniId(), false, entries.size(), e, null, this.ctx.deploymentEnabled(), false);
        }
    }

    private void sendLockReply(ClusterNode nearNode, @Nullable GridDhtTxLocal tx, GridNearLockRequest req, GridNearLockResponse res) {
        Throwable err = res.error();
        if (!(err == null || err instanceof GridCacheLockTimeoutException || err instanceof IgniteTxRollbackCheckedException || this.ctx.kernalContext().isStopping())) {
            U.error(this.log, "Failed to acquire lock for request: " + req, err);
        }
        try {
            if (!(nearNode.id().equals(this.ctx.nodeId()) || X.hasCause(err, GridDistributedLockCancelledException.class) || X.hasCause(err, IgniteTxRollbackCheckedException.class))) {
                this.ctx.io().send(nearNode, (GridCacheMessage)res, this.ctx.ioPolicy());
                if (this.txLockMsgLog.isDebugEnabled()) {
                    this.txLockMsgLog.debug("Sent near lock response [txId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nearNode.id() + "]");
                }
            } else if (this.txLockMsgLog.isDebugEnabled() && !nearNode.id().equals(this.ctx.nodeId())) {
                this.txLockMsgLog.debug("Skip send near lock response [txId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nearNode.id() + ", err=" + err + "]");
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txLockMsgLog, "Failed to send near lock response (will rollback transaction) [txId=" + req.version() + ", inTx=" + req.inTx() + ", node=" + nearNode.id() + ", res=" + res + "]", e);
            if (tx != null) {
                try {
                    tx.rollbackDhtLocalAsync();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            throw new GridClosureException(e);
        }
    }

    private Collection<GridCacheVersion> localDhtPendingVersions(Iterable<GridCacheEntryEx> entries, GridCacheVersion baseVer) {
        GridLeanSet<GridCacheVersion> lessPending = new GridLeanSet<GridCacheVersion>(5);
        block2: for (GridCacheEntryEx entry : entries) {
            while (true) {
                try {
                    for (GridCacheMvccCandidate cand : entry.localCandidates(new GridCacheVersion[0])) {
                        if (!cand.version().isLess(baseVer)) continue;
                        lessPending.add(cand.version());
                    }
                    continue block2;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Got removed entry is localDhtPendingVersions (will retry): " + entry);
                    }
                    entry = this.entryExx(entry.key());
                    continue;
                }
                break;
            }
        }
        return lessPending;
    }

    private void clearLocks(UUID nodeId, GridDistributedUnlockRequest req) {
        assert (nodeId != null);
        List<KeyCacheObject> keys = req.keys();
        if (keys != null) {
            block2: for (KeyCacheObject key : keys) {
                GridDhtCacheEntry entry;
                while ((entry = this.peekExx(key)) != null) {
                    try {
                        entry.doneRemote(req.version(), req.version(), null, null, null, false);
                        if (((GridDistributedCacheEntry)entry).removeLock(req.version())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Removed lock [lockId=" + req.version() + ", key=" + key + "]");
                            }
                        } else if (this.log.isDebugEnabled()) {
                            this.log.debug("Received unlock request for unknown candidate (added to cancelled locks set): " + req);
                        }
                        entry.touch();
                        continue block2;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Received remove lock request for removed entry (will retry) [entry=" + entry + ", req=" + req + "]");
                    }
                }
            }
        }
    }

    private void processNearUnlockRequest(UUID nodeId, GridNearUnlockRequest req) {
        assert (this.ctx.affinityNode());
        assert (nodeId != null);
        this.removeLocks(nodeId, req.version(), req.keys(), true);
    }

    private void map(UUID nodeId, AffinityTopologyVersion topVer, GridCacheEntryEx cached, Collection<UUID> readers, Map<ClusterNode, List<KeyCacheObject>> dhtMap, Map<ClusterNode, List<KeyCacheObject>> nearMap) {
        List<ClusterNode> dhtNodes = this.ctx.dht().topology().nodes(cached.partition(), topVer);
        ClusterNode primary = dhtNodes.get(0);
        assert (primary != null);
        if (!primary.id().equals(this.ctx.nodeId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Primary node mismatch for unlock [entry=" + cached + ", expected=" + this.ctx.nodeId() + ", actual=" + U.toShortString(primary) + "]");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Mapping entry to DHT nodes [nodes=" + U.toShortString(dhtNodes) + ", entry=" + cached + "]");
        }
        Collection<ClusterNode> nearNodes = null;
        if (!F.isEmpty(readers)) {
            nearNodes = this.ctx.discovery().nodes(readers, F0.not(F.idForNodeId(nodeId)));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mapping entry to near nodes [nodes=" + U.toShortString(nearNodes) + ", entry=" + cached + "]");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Entry has no near readers: " + cached);
        }
        this.map(cached, F.view(dhtNodes, F.remoteNodes(this.ctx.nodeId())), dhtMap);
        this.map(cached, nearNodes, nearMap);
    }

    private void map(GridCacheEntryEx entry, @Nullable Iterable<? extends ClusterNode> nodes, Map<ClusterNode, List<KeyCacheObject>> map) {
        if (nodes != null) {
            for (ClusterNode clusterNode : nodes) {
                List keys = map.computeIfAbsent(clusterNode, k -> new LinkedList());
                keys.add(entry.key());
            }
        }
    }

    public void removeLocks(UUID nodeId, GridCacheVersion ver, Iterable<KeyCacheObject> keys, boolean unmap) {
        GridDhtUnlockRequest req;
        List keyBytes;
        ClusterNode n;
        assert (nodeId != null);
        assert (ver != null);
        if (F.isEmpty(keys)) {
            return;
        }
        GridCacheVersion dhtVer = unmap ? this.ctx.mvcc().unmapVersion(ver) : ver;
        this.ctx.mvcc().addRemoved(this.ctx, ver);
        HashMap<ClusterNode, List<KeyCacheObject>> dhtMap = new HashMap<ClusterNode, List<KeyCacheObject>>();
        HashMap<ClusterNode, List<KeyCacheObject>> nearMap = new HashMap<ClusterNode, List<KeyCacheObject>>();
        GridCacheVersion obsoleteVer = null;
        block8: for (KeyCacheObject key : keys) {
            while (true) {
                boolean created = false;
                GridDhtCacheEntry entry = this.peekExx(key);
                if (entry == null) {
                    entry = this.entryExx(key);
                    created = true;
                }
                try {
                    GridCacheMvccCandidate cand = null;
                    if (dhtVer == null) {
                        cand = entry.localCandidateByNearVersion(ver, true);
                        if (cand != null) {
                            dhtVer = cand.version();
                        } else {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to locate lock candidate based on dht or near versions [nodeId=" + nodeId + ", ver=" + ver + ", unmap=" + unmap + ", keys=" + keys + "]");
                            }
                            entry.removeLock(ver);
                            if (!created) continue block8;
                            if (obsoleteVer == null) {
                                obsoleteVer = this.nextVersion();
                            }
                            if (!entry.markObsolete(obsoleteVer)) continue block8;
                            this.removeEntry(entry);
                            continue block8;
                        }
                    }
                    if (cand == null) {
                        cand = entry.candidate(dhtVer);
                    }
                    AffinityTopologyVersion topVer = cand == null ? AffinityTopologyVersion.NONE : cand.topologyVersion();
                    Collection<UUID> readers = entry.readers();
                    if (entry.removeLock(dhtVer)) {
                        this.map(nodeId, topVer, entry, readers, dhtMap, nearMap);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Removed lock [lockId=" + ver + ", key=" + key + "]");
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Received unlock request for unknown candidate (added to cancelled locks set) [ver=" + ver + ", entry=" + entry + "]");
                    }
                    if (created && entry.markObsolete(dhtVer)) {
                        this.removeEntry(entry);
                    }
                    entry.touch();
                    continue block8;
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Received remove lock request for removed entry (will retry): " + entry);
                    continue;
                }
                break;
            }
        }
        IgnitePair<Collection<GridCacheVersion>> versPair = this.ctx.tm().versions(ver);
        Collection committed = (Collection)versPair.get1();
        Collection rolledback = (Collection)versPair.get2();
        for (Map.Entry entry : dhtMap.entrySet()) {
            n = (ClusterNode)entry.getKey();
            keyBytes = (List)entry.getValue();
            req = new GridDhtUnlockRequest(this.ctx.cacheId(), keyBytes.size(), this.ctx.deploymentEnabled());
            req.version(dhtVer);
            try {
                for (KeyCacheObject key : keyBytes) {
                    req.addKey(key);
                }
                keyBytes = (List)nearMap.get(n);
                if (keyBytes != null) {
                    for (KeyCacheObject key : keyBytes) {
                        req.addNearKey(key);
                    }
                }
                req.completedVersions(committed, rolledback);
                this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
            }
            catch (ClusterTopologyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Node left while sending unlock request: " + n);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send unlock request to node (will make best effort to complete): " + n, e);
            }
        }
        for (Map.Entry entry : nearMap.entrySet()) {
            n = (ClusterNode)entry.getKey();
            if (dhtMap.containsKey(n)) continue;
            keyBytes = (List)entry.getValue();
            req = new GridDhtUnlockRequest(this.ctx.cacheId(), keyBytes.size(), this.ctx.deploymentEnabled());
            req.version(dhtVer);
            try {
                for (KeyCacheObject key : keyBytes) {
                    req.addNearKey(key);
                }
                req.completedVersions(committed, rolledback);
                this.ctx.io().send(n, (GridCacheMessage)req, this.ctx.ioPolicy());
            }
            catch (ClusterTopologyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Node left while sending unlock request: " + n);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send unlock request to node (will make best effort to complete): " + n, e);
            }
        }
    }

    private void invalidateNearEntry(KeyCacheObject key, GridCacheVersion ver) throws IgniteCheckedException {
        GridCacheEntryEx nearEntry = this.near().peekEx(key);
        if (nearEntry != null) {
            nearEntry.invalidate(ver);
        }
    }

    private void obsoleteNearEntry(KeyCacheObject key) {
        GridCacheEntryEx nearEntry = this.near().peekEx(key);
        if (nearEntry != null) {
            nearEntry.markObsolete(this.nextVersion());
        }
    }
}

