/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partitiondistribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Assignments {
    public static final Assignments EMPTY = new Assignments(Collections.emptySet(), false, 0L, false);
    @IgniteToStringInclude
    private final HashSet<Assignment> nodes;
    private final boolean force;
    private final long timestamp;
    private final boolean fromReset;

    private Assignments(Collection<Assignment> nodes, boolean force, long timestamp, boolean fromReset) {
        this.nodes = nodes instanceof HashSet ? (HashSet<Object>)nodes : new HashSet<Assignment>(nodes);
        this.force = force;
        this.timestamp = timestamp;
        this.fromReset = fromReset;
        assert (!force || !fromReset) : "Only one flag can be set from 'force' and 'fromReset'.";
    }

    public static Assignments of(Set<Assignment> nodes, long timestamp) {
        return new Assignments(nodes, false, timestamp, false);
    }

    public static Assignments of(Set<Assignment> nodes, long timestamp, boolean fromReset) {
        return new Assignments(nodes, false, timestamp, fromReset);
    }

    public static Assignments of(long timestamp, Assignment ... nodes) {
        return new Assignments(Arrays.asList(nodes), false, timestamp, false);
    }

    public static Assignments forced(Set<Assignment> nodes, long timestamp) {
        return new Assignments(nodes, true, timestamp, false);
    }

    public Set<Assignment> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public boolean force() {
        return this.force;
    }

    public boolean fromReset() {
        return this.fromReset;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public void add(Assignment assignment) {
        this.nodes.add(assignment);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public byte[] toBytes() {
        return VersionedSerialization.toBytes(this, AssignmentsSerializer.INSTANCE);
    }

    public static byte[] toBytes(Set<Assignment> assignments, long timestamp) {
        return new Assignments(assignments, false, timestamp, false).toBytes();
    }

    public static byte[] toBytes(Set<Assignment> assignments, long timestamp, boolean fromReset) {
        return new Assignments(assignments, false, timestamp, fromReset).toBytes();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static Assignments fromBytes(byte @Nullable [] bytes) {
        return bytes == null ? null : VersionedSerialization.fromBytes(bytes, AssignmentsSerializer.INSTANCE);
    }

    public String toString() {
        return S.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignments that = (Assignments)o;
        return this.force == that.force && this.nodes.equals(that.nodes) && this.fromReset == that.fromReset;
    }

    public int hashCode() {
        int result = this.nodes.hashCode();
        result = 31 * result + Boolean.hashCode(this.force);
        result = 31 * result + Boolean.hashCode(this.fromReset);
        return result;
    }

    public static String assignmentListToString(List<Assignments> assignments) {
        return S.toString(assignments, (sb, e, i) -> sb.app(i).app('=').app(e.nodes()));
    }
}

