/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range.hinter;

import com.google.protobuf.ByteString;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class LoadRecordWindow {
    private final AtomicInteger records = new AtomicInteger();
    private final AtomicInteger totalKVIOs = new AtomicInteger();
    private final AtomicLong totalKVIONanos = new AtomicLong();
    private final AtomicLong totalLatency = new AtomicLong();
    private final Map<ByteString, AtomicLong> loadDistribution = new ConcurrentHashMap<ByteString, AtomicLong>();

    LoadRecordWindow() {
    }

    void record(Map<ByteString, Long> keyLoads, int kvIOs, long kvIOTimeNanos, long latencyNanos) {
        keyLoads.forEach((key, keyAccessNanos) -> this.loadDistribution.computeIfAbsent((ByteString)key, k -> new AtomicLong()).addAndGet((long)keyAccessNanos));
        this.totalKVIOs.addAndGet(kvIOs);
        this.totalKVIONanos.addAndGet(kvIOTimeNanos);
        this.totalLatency.addAndGet(latencyNanos);
        this.records.incrementAndGet();
    }

    public int records() {
        return this.records.get();
    }

    public int ioDensity() {
        return (int)Math.ceil((double)this.totalKVIOs.get() / Math.max((double)this.records.get(), 1.0));
    }

    public long ioLatencyNanos() {
        return this.totalKVIONanos.get() / (long)Math.max(this.totalKVIOs.get(), 1);
    }

    public long avgLatencyNanos() {
        return this.totalLatency.get() / (long)Math.max(this.records.get(), 1);
    }

    public Optional<ByteString> estimateSplitKey() {
        long loadSum = 0L;
        long totalKeyIONanos = 0L;
        TreeMap<ByteString, AtomicLong> slotDistro = new TreeMap<ByteString, AtomicLong>(ByteString.unsignedLexicographicalComparator());
        for (Map.Entry<ByteString, AtomicLong> entry : this.loadDistribution.entrySet()) {
            slotDistro.put(entry.getKey(), entry.getValue());
            totalKeyIONanos += entry.getValue().get();
        }
        long halfTotal = totalKeyIONanos / 2L;
        for (Map.Entry e : slotDistro.entrySet()) {
            if ((loadSum += ((AtomicLong)e.getValue()).get()) < halfTotal) continue;
            return Optional.of((ByteString)e.getKey());
        }
        return Optional.empty();
    }
}

