/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import com.google.common.collect.Maps;
import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.DummyServerSelector;
import org.apache.bifromq.baserpc.client.IClientChannel;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.IUnaryCaller;
import org.apache.bifromq.baserpc.client.ManagedMessageStream;
import org.apache.bifromq.baserpc.client.ManagedRequestPipeline;
import org.apache.bifromq.baserpc.client.UnaryCaller;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerSelector;
import org.apache.bifromq.baserpc.metrics.RPCMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RPCClient
implements IRPCClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCClient.class);
    private final BluePrint bluePrint;
    private final IClientChannel channelHolder;
    private final CallOptions defaultCallOptions;
    private final RPCMeter meter;
    private final Map<String, IUnaryCaller<?, ?>> unaryCallers = Maps.newHashMap();
    private final Map<String, AtomicInteger> unaryInflightCounts = Maps.newHashMap();
    private final Disposable disposable;
    private volatile IServerSelector serverSelector = DummyServerSelector.INSTANCE;

    RPCClient(@NonNull BluePrint bluePrint, @NonNull IClientChannel channelHolder) {
        if (bluePrint == null) {
            throw new NullPointerException("bluePrint is marked non-null but is null");
        }
        if (channelHolder == null) {
            throw new NullPointerException("channelHolder is marked non-null but is null");
        }
        this.channelHolder = channelHolder;
        this.bluePrint = bluePrint;
        this.meter = new RPCMeter(bluePrint.serviceDescriptor(), bluePrint);
        this.defaultCallOptions = CallOptions.DEFAULT;
        for (String fullMethodName : bluePrint.allMethods()) {
            if (!(bluePrint.semantic(fullMethodName) instanceof BluePrint.Unary)) continue;
            MethodDescriptor methodDesc = bluePrint.methodDesc(fullMethodName);
            this.unaryInflightCounts.put(fullMethodName, new AtomicInteger());
            this.unaryCallers.put(fullMethodName, new UnaryCaller(() -> this.serverSelector, channelHolder.channel(), this.defaultCallOptions, methodDesc, bluePrint, this.meter.get(methodDesc), this.unaryInflightCounts.get(methodDesc.getFullMethodName())));
        }
        this.disposable = channelHolder.serverSelectorObservable().subscribe(serverSelector -> {
            this.serverSelector = serverSelector;
        });
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.channelHolder.shutdown(5L, TimeUnit.SECONDS);
    }

    @Override
    public Observable<Map<String, Map<String, String>>> serverList() {
        return this.channelHolder.serverList();
    }

    @Override
    public Observable<IConnectable.ConnState> connState() {
        return this.channelHolder.connState();
    }

    @Override
    public <ReqT, RespT> CompletableFuture<RespT> invoke(String tenantId, String desiredServerId, ReqT req, @NonNull Map<String, String> metadata, MethodDescriptor<ReqT, RespT> methodDesc) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        IUnaryCaller<?, ?> caller = this.unaryCallers.get(methodDesc.getFullMethodName());
        return caller.invoke(tenantId, desiredServerId, req, metadata);
    }

    @Override
    public <ReqT, RespT> IRPCClient.IRequestPipeline<ReqT, RespT> createRequestPipeline(String tenantId, String desiredServerId, String wchKey, Supplier<Map<String, String>> metadataSupplier, MethodDescriptor<ReqT, RespT> methodDesc) {
        return new ManagedRequestPipeline<ReqT, RespT>(tenantId, wchKey, desiredServerId, metadataSupplier, this.channelHolder, this.defaultCallOptions, methodDesc, this.bluePrint, this.meter.get(methodDesc));
    }

    @Override
    public <MsgT, AckT> IRPCClient.IMessageStream<MsgT, AckT> createMessageStream(String tenantId, String desiredServerId, String wchKey, Supplier<Map<String, String>> metadataSupplier, MethodDescriptor<AckT, MsgT> methodDesc) {
        return new ManagedMessageStream<MsgT, AckT>(tenantId, wchKey, desiredServerId, metadataSupplier, this.channelHolder, this.defaultCallOptions, methodDesc, this.bluePrint, this.meter.get(methodDesc));
    }
}

