/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basescheduler.spi.ICapacityEstimator;
import org.apache.bifromq.basescheduler.spi.ICapacityEstimatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CapacityEstimatorFactory
implements ICapacityEstimatorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CapacityEstimatorFactory.class);
    public static final ICapacityEstimatorFactory INSTANCE = new CapacityEstimatorFactory();
    private final ICapacityEstimatorFactory delegate;

    private CapacityEstimatorFactory() {
        Map factoryMap = BaseHookLoader.load(ICapacityEstimatorFactory.class);
        if (factoryMap.isEmpty()) {
            this.delegate = FallbackFactory.INSTANCE;
        } else {
            this.delegate = (ICapacityEstimatorFactory)factoryMap.values().iterator().next();
            if (factoryMap.size() > 1) {
                log.warn("Multiple CapacityEstimatorFactory implementations found, the first loaded will be used:{}", (Object)this.delegate.getClass().getName());
            }
        }
    }

    @Override
    public <BatcherKey> ICapacityEstimator<BatcherKey> get(String name, BatcherKey batcherKey) {
        try {
            ICapacityEstimator<BatcherKey> estimator = this.delegate.get(name, batcherKey);
            if (estimator == null) {
                return FallbackFactory.INSTANCE.get(name, batcherKey);
            }
            return estimator;
        }
        catch (Throwable e) {
            log.error("Failed to create CapacityEstimator: scheduler={}", (Object)name, (Object)e);
            return FallbackFactory.INSTANCE.get(name, batcherKey);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static class FallbackFactory
    implements ICapacityEstimatorFactory {
        private static final ICapacityEstimatorFactory INSTANCE = new FallbackFactory();

        private FallbackFactory() {
        }

        @Override
        public <BatcherKey> ICapacityEstimator<BatcherKey> get(String name, BatcherKey batcherKey) {
            return new FallbackCapacityEstimator();
        }
    }

    private static class FallbackCapacityEstimator<BatcherKey>
    implements ICapacityEstimator<BatcherKey> {
        private FallbackCapacityEstimator() {
        }

        @Override
        public void record(long weightedSize, long latencyNs) {
        }

        @Override
        public boolean hasCapacity(long inflight, BatcherKey key) {
            return inflight <= 0L;
        }

        @Override
        public long maxCapacity(BatcherKey key) {
            return Long.MAX_VALUE;
        }

        @Override
        public void onBackPressure() {
        }
    }
}

