/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVIterator;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.api.IKVWriter;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.dist.rpc.proto.BatchDistReply;
import org.apache.bifromq.dist.rpc.proto.BatchDistRequest;
import org.apache.bifromq.dist.rpc.proto.BatchMatchReply;
import org.apache.bifromq.dist.rpc.proto.BatchMatchRequest;
import org.apache.bifromq.dist.rpc.proto.BatchUnmatchReply;
import org.apache.bifromq.dist.rpc.proto.BatchUnmatchRequest;
import org.apache.bifromq.dist.rpc.proto.DistPack;
import org.apache.bifromq.dist.rpc.proto.DistServiceROCoProcInput;
import org.apache.bifromq.dist.rpc.proto.DistServiceROCoProcOutput;
import org.apache.bifromq.dist.rpc.proto.DistServiceRWCoProcInput;
import org.apache.bifromq.dist.rpc.proto.DistServiceRWCoProcOutput;
import org.apache.bifromq.dist.rpc.proto.Fact;
import org.apache.bifromq.dist.rpc.proto.GCReply;
import org.apache.bifromq.dist.rpc.proto.GCRequest;
import org.apache.bifromq.dist.rpc.proto.GlobalFilterLevels;
import org.apache.bifromq.dist.rpc.proto.MatchRoute;
import org.apache.bifromq.dist.rpc.proto.RouteGroup;
import org.apache.bifromq.dist.rpc.proto.TopicFanout;
import org.apache.bifromq.dist.worker.Comparators;
import org.apache.bifromq.dist.worker.IDeliverExecutorGroup;
import org.apache.bifromq.dist.worker.ISubscriptionCleaner;
import org.apache.bifromq.dist.worker.ITenantsStats;
import org.apache.bifromq.dist.worker.cache.ISubscriptionCache;
import org.apache.bifromq.dist.worker.cache.task.AddRoutesTask;
import org.apache.bifromq.dist.worker.cache.task.RemoveRoutesTask;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.dist.worker.schema.cache.GroupMatching;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.dist.worker.schema.cache.NormalMatching;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetail;
import org.apache.bifromq.dist.worker.schema.cache.RouteDetailCache;
import org.apache.bifromq.dist.worker.schema.cache.RouteGroupCache;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.type.RouteMatcher;
import org.apache.bifromq.type.TopicMessagePack;
import org.apache.bifromq.util.BSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistWorkerCoProc
implements IKVRangeCoProc {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistWorkerCoProc.class);
    private final Supplier<IKVRangeRefreshableReader> readerProvider;
    private final ISubscriptionCache routeCache;
    private final ITenantsStats tenantsState;
    private final IDeliverExecutorGroup deliverExecutorGroup;
    private final ISubscriptionCleaner subscriptionChecker;
    private transient Fact fact;
    private transient Boundary boundary;

    public DistWorkerCoProc(KVRangeId id, Supplier<IKVRangeRefreshableReader> refreshableReaderProvider, ISubscriptionCache routeCache, ITenantsStats tenantsState, IDeliverExecutorGroup deliverExecutorGroup, ISubscriptionCleaner subscriptionChecker) {
        this.readerProvider = refreshableReaderProvider;
        this.routeCache = routeCache;
        this.tenantsState = tenantsState;
        this.deliverExecutorGroup = deliverExecutorGroup;
        this.subscriptionChecker = subscriptionChecker;
    }

    public CompletableFuture<ROCoProcOutput> query(ROCoProcInput input, IKVRangeReader reader) {
        try {
            DistServiceROCoProcInput coProcInput = input.getDistService();
            switch (coProcInput.getInputCase()) {
                case BATCHDIST: {
                    return this.batchDist(coProcInput.getBatchDist()).thenApply(v -> ROCoProcOutput.newBuilder().setDistService(DistServiceROCoProcOutput.newBuilder().setBatchDist(v).build()).build());
                }
                case GC: {
                    return this.gc(coProcInput.getGc(), reader).thenApply(v -> ROCoProcOutput.newBuilder().setDistService(DistServiceROCoProcOutput.newBuilder().setGc(v).build()).build());
                }
            }
            log.error("Unknown co proc type {}", (Object)coProcInput.getInputCase());
            CompletableFuture<ROCoProcOutput> f = new CompletableFuture<ROCoProcOutput>();
            f.completeExceptionally(new IllegalStateException("Unknown co proc type " + String.valueOf(coProcInput.getInputCase())));
            return f;
        }
        catch (Throwable e) {
            log.error("Unable to parse ro co-proc", e);
            CompletableFuture<ROCoProcOutput> f = new CompletableFuture<ROCoProcOutput>();
            f.completeExceptionally(new IllegalStateException("Unable to parse ro co-proc", e));
            return f;
        }
    }

    public Supplier<IKVRangeCoProc.MutationResult> mutate(RWCoProcInput input, IKVRangeReader reader, IKVWriter writer, boolean isLeader) {
        DistServiceRWCoProcInput coProcInput = input.getDistService();
        log.trace("Receive rw co-proc request\n{}", (Object)coProcInput);
        TreeMap addedMatches = Maps.newTreeMap();
        TreeMap removedMatches = Maps.newTreeMap();
        DistServiceRWCoProcOutput.Builder outputBuilder = DistServiceRWCoProcOutput.newBuilder();
        AtomicReference<Runnable> afterMutate = new AtomicReference<Runnable>();
        switch (coProcInput.getTypeCase()) {
            case BATCHMATCH: {
                BatchMatchReply.Builder replyBuilder = BatchMatchReply.newBuilder();
                afterMutate.set(this.batchAddRoute(coProcInput.getBatchMatch(), reader, writer, isLeader, addedMatches, removedMatches, replyBuilder));
                outputBuilder.setBatchMatch(replyBuilder.build());
                break;
            }
            case BATCHUNMATCH: {
                BatchMatchReply.Builder replyBuilder = BatchUnmatchReply.newBuilder();
                afterMutate.set(this.batchRemoveRoute(coProcInput.getBatchUnmatch(), reader, writer, isLeader, removedMatches, (BatchUnmatchReply.Builder)replyBuilder));
                outputBuilder.setBatchUnmatch(replyBuilder.build());
                break;
            }
        }
        RWCoProcOutput output = RWCoProcOutput.newBuilder().setDistService(outputBuilder.build()).build();
        return () -> {
            if (!addedMatches.isEmpty()) {
                this.routeCache.refresh(Maps.transformValues((NavigableMap)addedMatches, AddRoutesTask::of));
                addedMatches.forEach((tenantId, topicFilters) -> topicFilters.forEach((topicFilter, matchings) -> {
                    if (topicFilter.getType() == RouteMatcher.Type.OrderedShare) {
                        this.deliverExecutorGroup.refreshOrderedShareSubRoutes((String)tenantId, (RouteMatcher)topicFilter);
                    }
                }));
            }
            if (!removedMatches.isEmpty()) {
                this.routeCache.refresh(Maps.transformValues((NavigableMap)removedMatches, RemoveRoutesTask::of));
                removedMatches.forEach((tenantId, topicFilters) -> topicFilters.forEach((topicFilter, matchings) -> {
                    if (topicFilter.getType() == RouteMatcher.Type.OrderedShare) {
                        this.deliverExecutorGroup.refreshOrderedShareSubRoutes((String)tenantId, (RouteMatcher)topicFilter);
                    }
                }));
            }
            ((Runnable)afterMutate.get()).run();
            this.refreshFact(addedMatches, removedMatches, coProcInput.getTypeCase() == DistServiceRWCoProcInput.TypeCase.BATCHMATCH);
            return new IKVRangeCoProc.MutationResult(output, Optional.of(Any.pack((Message)this.fact)));
        };
    }

    private void refreshFact(NavigableMap<String, NavigableMap<RouteMatcher, Set<Matching>>> added, NavigableMap<String, NavigableMap<RouteMatcher, Set<Matching>>> removed, boolean isAdd) {
        if (added.isEmpty() && removed.isEmpty()) {
            return;
        }
        boolean needRefresh = false;
        if (!this.fact.hasFirstGlobalFilterLevels() || !this.fact.hasLastGlobalFilterLevels()) {
            needRefresh = true;
        } else if (isAdd) {
            firstMutation = added.firstEntry();
            lastMutation = added.lastEntry();
            firstRoute = this.toGlobalTopicLevels(firstMutation.getKey(), (RouteMatcher)firstMutation.getValue().firstKey());
            lastRoute = this.toGlobalTopicLevels(lastMutation.getKey(), (RouteMatcher)lastMutation.getValue().lastKey());
            if (Comparators.FilterLevelsComparator.compare(firstRoute, (Iterable<String>)this.fact.getFirstGlobalFilterLevels().getFilterLevelList()) < 0 || Comparators.FilterLevelsComparator.compare(lastRoute, (Iterable<String>)this.fact.getLastGlobalFilterLevels().getFilterLevelList()) > 0) {
                needRefresh = true;
            }
        } else {
            firstMutation = removed.firstEntry();
            lastMutation = removed.lastEntry();
            firstRoute = this.toGlobalTopicLevels(firstMutation.getKey(), (RouteMatcher)firstMutation.getValue().firstKey());
            lastRoute = this.toGlobalTopicLevels(lastMutation.getKey(), (RouteMatcher)lastMutation.getValue().lastKey());
            if (Comparators.FilterLevelsComparator.compare(firstRoute, (Iterable<String>)this.fact.getFirstGlobalFilterLevels().getFilterLevelList()) == 0 || Comparators.FilterLevelsComparator.compare(lastRoute, (Iterable<String>)this.fact.getLastGlobalFilterLevels().getFilterLevelList()) == 0) {
                needRefresh = true;
            }
        }
        if (needRefresh) {
            try (IKVRangeRefreshableReader reader = this.readerProvider.get();
                 IKVIterator itr = reader.iterator();){
                this.setFact(itr);
            }
        }
    }

    private Iterable<String> toGlobalTopicLevels(String tenantId, RouteMatcher routeMatcher) {
        return Iterables.concat(Collections.singletonList(tenantId), (Iterable)routeMatcher.getFilterLevelList());
    }

    private void setFact(IKVIterator itr) {
        Fact.Builder factBuilder = Fact.newBuilder();
        itr.seekToFirst();
        if (itr.isValid()) {
            RouteDetail firstRouteDetail = RouteDetailCache.get((ByteString)itr.key());
            factBuilder.setFirstGlobalFilterLevels(GlobalFilterLevels.newBuilder().addFilterLevel(firstRouteDetail.tenantId()).addAllFilterLevel((Iterable)firstRouteDetail.matcher().getFilterLevelList()).build());
        }
        itr.seekToLast();
        if (itr.isValid()) {
            RouteDetail lastRouteDetail = RouteDetailCache.get((ByteString)itr.key());
            factBuilder.setLastGlobalFilterLevels(GlobalFilterLevels.newBuilder().addFilterLevel(lastRouteDetail.tenantId()).addAllFilterLevel((Iterable)lastRouteDetail.matcher().getFilterLevelList()).build());
        }
        this.fact = factBuilder.build();
    }

    public Any reset(Boundary boundary) {
        this.tenantsState.reset();
        try (IKVRangeRefreshableReader reader = this.readerProvider.get();
             IKVIterator itr = reader.iterator();){
            this.boundary = boundary;
            this.routeCache.reset(boundary);
            this.setFact(itr);
        }
        return Any.pack((Message)this.fact);
    }

    public void onLeader(boolean isLeader) {
        this.tenantsState.toggleMetering(isLeader);
    }

    public void close() {
        this.tenantsState.close();
        this.routeCache.close();
        this.deliverExecutorGroup.shutdown();
    }

    private Runnable batchAddRoute(BatchMatchRequest request, IKVRangeReader reader, IKVWriter writer, boolean isLeader, Map<String, NavigableMap<RouteMatcher, Set<Matching>>> newMatches, Map<String, NavigableMap<RouteMatcher, Set<Matching>>> removedMatches, BatchMatchReply.Builder replyBuilder) {
        replyBuilder.setReqId(request.getReqId());
        HashMap normalRoutesAdded = new HashMap();
        HashMap sharedRoutesAdded = new HashMap();
        HashMap<GlobalTopicFilter, Map> groupMatchRecords = new HashMap<GlobalTopicFilter, Map>();
        HashMap<String, BatchMatchReply.TenantBatch.Code[]> resultMap = new HashMap<String, BatchMatchReply.TenantBatch.Code[]>();
        request.getRequestsMap().forEach((tenantId, tenantMatchRequest) -> {
            BatchMatchReply.TenantBatch.Code[] codes = resultMap.computeIfAbsent((String)tenantId, k -> new BatchMatchReply.TenantBatch.Code[tenantMatchRequest.getRouteCount()]);
            HashSet<ByteString> addedMatches = new HashSet<ByteString>();
            for (int i = 0; i < tenantMatchRequest.getRouteCount(); ++i) {
                MatchRoute route = tenantMatchRequest.getRoute(i);
                long incarnation = route.getIncarnation();
                RouteMatcher requestMatcher = route.getMatcher();
                if (requestMatcher.getType() == RouteMatcher.Type.Normal) {
                    String receiverUrl = KVSchemaUtil.toReceiverUrl((MatchRoute)route);
                    ByteString normalRouteKey = KVSchemaUtil.toNormalRouteKey((String)tenantId, (RouteMatcher)requestMatcher, (String)receiverUrl);
                    Optional<Long> incarOpt = reader.get(normalRouteKey).map(BSUtil::toLong);
                    if (incarOpt.isEmpty() || incarOpt.get() < incarnation) {
                        RouteDetail routeDetail = RouteDetailCache.get((ByteString)normalRouteKey);
                        Matching normalMatching = KVSchemaUtil.buildNormalMatchRoute((RouteDetail)routeDetail, (long)incarnation);
                        writer.put(normalRouteKey, BSUtil.toByteString((long)incarnation));
                        if (!addedMatches.contains(normalRouteKey) && incarOpt.isEmpty()) {
                            normalRoutesAdded.computeIfAbsent(tenantId, k -> new AtomicInteger()).incrementAndGet();
                        }
                        newMatches.computeIfAbsent((String)tenantId, k -> new TreeMap(Comparators.RouteMatcherComparator)).computeIfAbsent(routeDetail.matcher(), k -> new HashSet()).add(normalMatching);
                        if (incarOpt.isPresent()) {
                            Matching replacedMatching = KVSchemaUtil.buildNormalMatchRoute((RouteDetail)routeDetail, (long)incarOpt.get());
                            removedMatches.computeIfAbsent((String)tenantId, k -> new TreeMap(Comparators.RouteMatcherComparator)).computeIfAbsent(routeDetail.matcher(), k -> new HashSet()).add(replacedMatching);
                        }
                        addedMatches.add(normalRouteKey);
                    }
                    codes[i] = BatchMatchReply.TenantBatch.Code.OK;
                    continue;
                }
                ByteString groupRouteKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)requestMatcher);
                RouteDetail routeDetail = RouteDetailCache.get((ByteString)groupRouteKey);
                groupMatchRecords.computeIfAbsent(new GlobalTopicFilter((String)tenantId, routeDetail.matcher()), k -> new HashMap()).put(route, i);
            }
        });
        groupMatchRecords.forEach((globalTopicFilter, newGroupMembers) -> {
            String tenantId = globalTopicFilter.tenantId;
            RouteMatcher origRouteMatcher = globalTopicFilter.routeMatcher;
            ByteString groupMatchRecordKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)origRouteMatcher);
            RouteGroup.Builder matchGroup = reader.get(groupMatchRecordKey).map(b -> RouteGroupCache.get((ByteString)b).toBuilder()).orElseGet(() -> {
                sharedRoutesAdded.computeIfAbsent(tenantId, k -> new AtomicInteger()).incrementAndGet();
                return RouteGroup.newBuilder();
            });
            boolean updated = false;
            int maxMembers = ((BatchMatchRequest.TenantBatch)request.getRequestsMap().get(tenantId)).getOption().getMaxReceiversPerSharedSubGroup();
            for (MatchRoute route : newGroupMembers.keySet()) {
                int resultIdx = (Integer)newGroupMembers.get(route);
                String receiverUrl = KVSchemaUtil.toReceiverUrl((MatchRoute)route);
                if (!matchGroup.containsMembers(receiverUrl)) {
                    if (matchGroup.getMembersCount() < maxMembers) {
                        matchGroup.putMembers(receiverUrl, route.getIncarnation());
                        ((BatchMatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx] = BatchMatchReply.TenantBatch.Code.OK;
                        updated = true;
                        continue;
                    }
                    ((BatchMatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx] = BatchMatchReply.TenantBatch.Code.EXCEED_LIMIT;
                    continue;
                }
                if ((Long)matchGroup.getMembersMap().get(receiverUrl) < route.getIncarnation()) {
                    matchGroup.putMembers(receiverUrl, route.getIncarnation());
                    updated = true;
                }
                ((BatchMatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx] = BatchMatchReply.TenantBatch.Code.OK;
            }
            if (updated) {
                RouteDetail routeDetail = RouteDetailCache.get((ByteString)groupMatchRecordKey);
                RouteGroup routeGroup = matchGroup.build();
                Matching groupMatching = KVSchemaUtil.buildGroupMatchRoute((RouteDetail)routeDetail, (RouteGroup)routeGroup);
                writer.put(groupMatchRecordKey, routeGroup.toByteString());
                newMatches.computeIfAbsent(tenantId, k -> new TreeMap(Comparators.RouteMatcherComparator)).computeIfAbsent(routeDetail.matcher(), k -> new HashSet()).add(groupMatching);
            }
        });
        resultMap.forEach((tenantId, codes) -> {
            BatchMatchReply.TenantBatch.Builder batchBuilder = BatchMatchReply.TenantBatch.newBuilder();
            for (BatchMatchReply.TenantBatch.Code code : codes) {
                batchBuilder.addCode(code);
            }
            replyBuilder.putResults(tenantId, batchBuilder.build());
        });
        return () -> {
            normalRoutesAdded.forEach((tenantId, added) -> this.tenantsState.incNormalRoutes((String)tenantId, added.get()));
            sharedRoutesAdded.forEach((tenantId, added) -> this.tenantsState.incSharedRoutes((String)tenantId, added.get()));
            this.tenantsState.toggleMetering(isLeader);
        };
    }

    private Runnable batchRemoveRoute(BatchUnmatchRequest request, IKVRangeReader reader, IKVWriter writer, boolean isLeader, Map<String, NavigableMap<RouteMatcher, Set<Matching>>> removedMatches, BatchUnmatchReply.Builder replyBuilder) {
        replyBuilder.setReqId(request.getReqId());
        HashMap normalRoutesRemoved = new HashMap();
        HashMap sharedRoutesRemoved = new HashMap();
        HashMap<GlobalTopicFilter, Map> delGroupMatchRecords = new HashMap<GlobalTopicFilter, Map>();
        HashMap<String, BatchUnmatchReply.TenantBatch.Code[]> resultMap = new HashMap<String, BatchUnmatchReply.TenantBatch.Code[]>();
        request.getRequestsMap().forEach((tenantId, tenantUnmatchRequest) -> {
            BatchUnmatchReply.TenantBatch.Code[] codes = resultMap.computeIfAbsent((String)tenantId, k -> new BatchUnmatchReply.TenantBatch.Code[tenantUnmatchRequest.getRouteCount()]);
            HashSet<ByteString> delMatches = new HashSet<ByteString>();
            for (int i = 0; i < tenantUnmatchRequest.getRouteCount(); ++i) {
                MatchRoute route = tenantUnmatchRequest.getRoute(i);
                RouteMatcher requestMatcher = route.getMatcher();
                if (requestMatcher.getType() == RouteMatcher.Type.Normal) {
                    String receiverUrl = KVSchemaUtil.toReceiverUrl((MatchRoute)route);
                    ByteString normalRouteKey = KVSchemaUtil.toNormalRouteKey((String)tenantId, (RouteMatcher)requestMatcher, (String)receiverUrl);
                    Optional<Long> incarOpt = reader.get(normalRouteKey).map(BSUtil::toLong);
                    if (incarOpt.isPresent() && incarOpt.get() <= route.getIncarnation()) {
                        RouteDetail routeDetail = RouteDetailCache.get((ByteString)normalRouteKey);
                        Matching normalMatching = KVSchemaUtil.buildNormalMatchRoute((RouteDetail)routeDetail, (long)incarOpt.get());
                        writer.delete(normalRouteKey);
                        if (!delMatches.contains(normalRouteKey)) {
                            normalRoutesRemoved.computeIfAbsent(tenantId, k -> new AtomicInteger()).incrementAndGet();
                        }
                        removedMatches.computeIfAbsent((String)tenantId, k -> new TreeMap(Comparators.RouteMatcherComparator)).computeIfAbsent(routeDetail.matcher(), k -> new HashSet()).add(normalMatching);
                        delMatches.add(normalRouteKey);
                        codes[i] = BatchUnmatchReply.TenantBatch.Code.OK;
                        continue;
                    }
                    codes[i] = BatchUnmatchReply.TenantBatch.Code.NOT_EXISTED;
                    continue;
                }
                ByteString groupRouteKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)requestMatcher);
                RouteDetail routeDetail = RouteDetailCache.get((ByteString)groupRouteKey);
                delGroupMatchRecords.computeIfAbsent(new GlobalTopicFilter((String)tenantId, routeDetail.matcher()), k -> new HashMap()).put(route, i);
            }
        });
        delGroupMatchRecords.forEach((globalTopicFilter, delGroupMembers) -> {
            String tenantId = globalTopicFilter.tenantId;
            RouteMatcher origRouteMatcher = globalTopicFilter.routeMatcher;
            ByteString groupRouteKey = KVSchemaUtil.toGroupRouteKey((String)tenantId, (RouteMatcher)origRouteMatcher);
            Optional value = reader.get(groupRouteKey);
            if (value.isPresent()) {
                Matching matching = KVSchemaUtil.buildMatchRoute((ByteString)groupRouteKey, (ByteString)((ByteString)value.get()));
                assert (matching instanceof GroupMatching);
                GroupMatching groupMatching = (GroupMatching)matching;
                HashMap existing = Maps.newHashMap((Map)groupMatching.receivers());
                delGroupMembers.forEach((route, resultIdx) -> {
                    String receiverUrl = KVSchemaUtil.toReceiverUrl((MatchRoute)route);
                    if (existing.containsKey(receiverUrl) && (Long)existing.get(receiverUrl) <= route.getIncarnation()) {
                        existing.remove(receiverUrl);
                        ((BatchUnmatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx.intValue()] = BatchUnmatchReply.TenantBatch.Code.OK;
                    } else {
                        ((BatchUnmatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx.intValue()] = BatchUnmatchReply.TenantBatch.Code.NOT_EXISTED;
                    }
                });
                if (existing.size() != groupMatching.receivers().size()) {
                    if (existing.isEmpty()) {
                        writer.delete(groupRouteKey);
                        sharedRoutesRemoved.computeIfAbsent(tenantId, k -> new AtomicInteger()).incrementAndGet();
                    } else {
                        writer.put(groupRouteKey, RouteGroup.newBuilder().putAllMembers((Map)existing).build().toByteString());
                    }
                    RouteDetail routeDetail = RouteDetailCache.get((ByteString)groupRouteKey);
                    RouteGroup routeGroup = RouteGroup.newBuilder().putAllMembers((Map)existing).build();
                    Matching newGroupMatching = KVSchemaUtil.buildGroupMatchRoute((RouteDetail)routeDetail, (RouteGroup)routeGroup);
                    removedMatches.computeIfAbsent(tenantId, k -> new TreeMap(Comparators.RouteMatcherComparator)).computeIfAbsent(routeDetail.matcher(), k -> new HashSet()).add(newGroupMatching);
                }
            } else {
                delGroupMembers.forEach((detail, resultIdx) -> {
                    ((BatchUnmatchReply.TenantBatch.Code[])resultMap.get((Object)tenantId))[resultIdx.intValue()] = BatchUnmatchReply.TenantBatch.Code.NOT_EXISTED;
                });
            }
        });
        resultMap.forEach((tenantId, codes) -> {
            BatchUnmatchReply.TenantBatch.Builder batchBuilder = BatchUnmatchReply.TenantBatch.newBuilder();
            for (BatchUnmatchReply.TenantBatch.Code code : codes) {
                batchBuilder.addCode(code);
            }
            replyBuilder.putResults(tenantId, batchBuilder.build());
        });
        return () -> {
            normalRoutesRemoved.forEach((tenantId, removed) -> this.tenantsState.decNormalRoutes((String)tenantId, removed.get()));
            sharedRoutesRemoved.forEach((tenantId, removed) -> this.tenantsState.decSharedRoutes((String)tenantId, removed.get()));
            this.tenantsState.toggleMetering(isLeader);
        };
    }

    private CompletableFuture<BatchDistReply> batchDist(BatchDistRequest request) {
        List distPackList = request.getDistPackList();
        if (distPackList.isEmpty()) {
            return CompletableFuture.completedFuture(BatchDistReply.newBuilder().setReqId(request.getReqId()).build());
        }
        LinkedList<CompletionStage> distFutures = new LinkedList<CompletionStage>();
        ConcurrentHashMap<String, Map> tenantTopicFanOuts = new ConcurrentHashMap<String, Map>();
        for (DistPack distPack : distPackList) {
            String tenantId = distPack.getTenantId();
            Map topicFanouts = tenantTopicFanOuts.computeIfAbsent(tenantId, k -> new ConcurrentHashMap());
            ByteString tenantStartKey = KVSchemaUtil.tenantBeginKey((String)tenantId);
            Boundary tenantBoundary = BoundaryUtil.intersect((Boundary)BoundaryUtil.toBoundary((ByteString)tenantStartKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantStartKey)), (Boundary)this.boundary);
            if (BoundaryUtil.isNULLRange((Boundary)tenantBoundary)) continue;
            for (TopicMessagePack topicMsgPack : distPack.getMsgPackList()) {
                String topic = topicMsgPack.getTopic();
                AtomicInteger fanout = topicFanouts.computeIfAbsent(topic, k -> new AtomicInteger());
                distFutures.add(this.routeCache.get(tenantId, topic).thenAccept(routes -> {
                    this.deliverExecutorGroup.submit(tenantId, (Set<Matching>)routes, topicMsgPack);
                    fanout.addAndGet(routes.size());
                }));
            }
        }
        return CompletableFuture.allOf(distFutures.toArray(new CompletableFuture[distFutures.size()])).thenApply(v -> {
            BatchDistReply.Builder replyBuilder = BatchDistReply.newBuilder().setReqId(request.getReqId());
            tenantTopicFanOuts.forEach((k, f) -> {
                TopicFanout.Builder fanoutBuilder = TopicFanout.newBuilder();
                f.forEach((topic, count) -> fanoutBuilder.putFanout(topic, count.get()));
                replyBuilder.putResult(k, fanoutBuilder.build());
            });
            return replyBuilder.build();
        });
    }

    private CompletableFuture<GCReply> gc(GCRequest request, IKVRangeReader reader) {
        int stepUsed = Math.max(request.getStepHint(), 1);
        int scanQuota = request.getScanQuota() > 0 ? request.getScanQuota() : 256 * stepUsed;
        HashMap<Integer, Map> checkRequestBuilders = new HashMap<Integer, Map>();
        try (IKVIterator itr = reader.iterator();){
            Object matching;
            Object startKey;
            if (request.hasStartKey()) {
                startKey = request.getStartKey();
                if (this.boundary != null) {
                    ByteString startBoundary = BoundaryUtil.startKey((Boundary)this.boundary);
                    ByteString endBoundary = BoundaryUtil.endKey((Boundary)this.boundary);
                    if (BoundaryUtil.compareStartKey((ByteString)startKey, (ByteString)startBoundary) < 0) {
                        startKey = startBoundary;
                    } else if (BoundaryUtil.compareEndKeys((ByteString)startKey, (ByteString)endBoundary) >= 0) {
                        startKey = startBoundary;
                    }
                }
                if (startKey != null) {
                    itr.seek(startKey);
                } else {
                    itr.seekToFirst();
                }
            } else {
                itr.seekToFirst();
            }
            if (!itr.isValid()) {
                startKey = CompletableFuture.completedFuture(GCReply.newBuilder().setReqId(request.getReqId()).setInspectedCount(0).setRemoveSuccess(0).setWrapped(true).build());
                return startKey;
            }
            AtomicInteger inspectedCount = new AtomicInteger();
            AtomicBoolean wrapped = new AtomicBoolean(false);
            ByteString sessionStartKey = null;
            AtomicReference<ByteString> nextStartKeySnapshot = new AtomicReference<ByteString>();
            block10: while (true) {
                if (!itr.isValid()) {
                    if (wrapped.get()) break;
                    itr.seekToFirst();
                    if (!itr.isValid()) break;
                    wrapped.set(true);
                }
                ByteString currentKey = itr.key();
                if (wrapped.get() && currentKey.equals(sessionStartKey)) break;
                if (sessionStartKey == null) {
                    sessionStartKey = currentKey;
                }
                matching = KVSchemaUtil.buildMatchRoute((ByteString)currentKey, (ByteString)itr.value());
                switch (matching.type()) {
                    case Normal: {
                        if (this.routeCache.isCached(matching.tenantId(), (List<String>)((Matching)matching).matcher.getFilterLevelList())) break;
                        NormalMatching normalMatching = (NormalMatching)matching;
                        checkRequestBuilders.computeIfAbsent(normalMatching.subBrokerId(), k -> new HashMap()).computeIfAbsent(normalMatching.delivererKey(), k -> new HashMap()).computeIfAbsent(normalMatching.tenantId(), k -> CheckRequest.newBuilder().setTenantId(k).setDelivererKey(normalMatching.delivererKey())).addMatchInfo(((NormalMatching)matching).matchInfo());
                        break;
                    }
                    case Group: {
                        GroupMatching groupMatching = (GroupMatching)matching;
                        if (this.routeCache.isCached(groupMatching.tenantId(), (List<String>)((Matching)matching).matcher.getFilterLevelList())) break;
                        for (NormalMatching normalMatching : groupMatching.receiverList) {
                            checkRequestBuilders.computeIfAbsent(normalMatching.subBrokerId(), k -> new HashMap()).computeIfAbsent(normalMatching.delivererKey(), k -> new HashMap()).computeIfAbsent(normalMatching.tenantId(), k -> CheckRequest.newBuilder().setTenantId(k).setDelivererKey(normalMatching.delivererKey())).addMatchInfo(normalMatching.matchInfo());
                        }
                        break;
                    }
                }
                inspectedCount.incrementAndGet();
                if (inspectedCount.get() >= scanQuota) {
                    itr.next();
                    break;
                }
                int skip = stepUsed - 1;
                while (skip-- > 0) {
                    itr.next();
                    if (itr.isValid()) continue;
                    continue block10;
                }
                itr.next();
            }
            if (itr.isValid()) {
                nextStartKeySnapshot.set(itr.key());
            }
            ArrayList<CompletableFuture<ISubscriptionCleaner.GCStats>> checkFutures = new ArrayList<CompletableFuture<ISubscriptionCleaner.GCStats>>();
            matching = checkRequestBuilders.keySet().iterator();
            while (matching.hasNext()) {
                int subBrokerId = (Integer)matching.next();
                for (String delivererKey : ((Map)checkRequestBuilders.get(subBrokerId)).keySet()) {
                    for (Map.Entry entry : ((Map)((Map)checkRequestBuilders.get(subBrokerId)).get(delivererKey)).entrySet()) {
                        checkFutures.add(this.subscriptionChecker.sweep(subBrokerId, ((CheckRequest.Builder)entry.getValue()).build()));
                    }
                }
            }
            CompletableFuture<Void> all = CompletableFuture.allOf((CompletableFuture[])checkFutures.toArray(CompletableFuture[]::new));
            CompletionStage completionStage = all.thenApply(v -> {
                int success = 0;
                for (CompletableFuture f : checkFutures) {
                    success += ((ISubscriptionCleaner.GCStats)f.join()).success();
                }
                GCReply.Builder reply = GCReply.newBuilder().setReqId(request.getReqId()).setInspectedCount(inspectedCount.get()).setRemoveSuccess(success).setWrapped(wrapped.get());
                if (nextStartKeySnapshot.get() != null) {
                    reply.setNextStartKey((ByteString)nextStartKeySnapshot.get());
                }
                return reply.build();
            });
            return completionStage;
        }
    }

    private record GlobalTopicFilter(String tenantId, RouteMatcher routeMatcher) {
    }
}

