/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import lombok.Generated;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.apache.bifromq.util.index.CNode;
import org.apache.bifromq.util.index.INode;
import org.apache.bifromq.util.index.MainNode;
import org.apache.bifromq.util.index.StrategySet;
import org.apache.bifromq.util.index.TNode;
import org.apache.bifromq.util.index.ValueStrategy;

public abstract class TopicLevelTrie<V> {
    private static final AtomicReferenceFieldUpdater<TopicLevelTrie, INode> ROOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TopicLevelTrie.class, INode.class, "root");
    private final ValueStrategy<V> strategy;
    private volatile INode<V> root = null;

    public TopicLevelTrie() {
        this(ValueStrategy.natural());
    }

    public TopicLevelTrie(ValueStrategy<V> strategy) {
        this.strategy = strategy;
        ROOT_UPDATER.compareAndSet(this, null, new INode<V>(new MainNode<V>(new CNode<V>(strategy))));
    }

    protected V add(List<String> topicLevels, V value) {
        INode<V> r;
        while (!this.insert(r = this.root(), null, null, topicLevels, value)) {
        }
        return value;
    }

    private boolean insert(INode<V> i, INode<V> parent, String keyFromParent, List<String> topicLevels, V value) {
        MainNode<V> main = i.main();
        if (main.cNode != null) {
            CNode<V> cn = main.cNode;
            Branch<V> br = cn.branches().get(topicLevels.get(0));
            if (br == null) {
                MainNode newMain = new MainNode(cn.inserted(topicLevels, value));
                return i.cas(main, newMain);
            }
            if (topicLevels.size() > 1) {
                if (br.iNode != null) {
                    return this.insert(br.iNode, i, topicLevels.get(0), topicLevels.subList(1, topicLevels.size()), value);
                }
                INode<V> nin = new INode<V>(new MainNode<V>(new CNode<V>(topicLevels.subList(1, topicLevels.size()), value, this.strategy)));
                MainNode newMain = new MainNode(cn.updatedBranch(topicLevels.get(0), nin, br));
                return i.cas(main, newMain);
            }
            if (br.contains(value)) {
                return true;
            }
            MainNode newMain = new MainNode(cn.updated(topicLevels.get(0), value));
            return i.cas(main, newMain);
        }
        if (main.tNode != null) {
            if (parent != null) {
                if (keyFromParent != null) {
                    this.clean(parent, keyFromParent);
                } else {
                    this.clean(parent);
                }
            }
            return false;
        }
        throw new IllegalStateException("TopicLevelTrie is in an invalid state");
    }

    protected void remove(List<String> topicLevels, V value) {
        Frame<V> rootF;
        INode<V> r;
        while (!this.remove(r = this.root(), null, topicLevels, 0, value, rootF = new Frame<V>(r, null, null))) {
        }
    }

    private boolean remove(INode<V> i, INode<V> parent, List<String> topicLevels, int levelIndex, V value, Frame<V> top) {
        MainNode<V> main = i.main();
        if (main.cNode != null) {
            CNode<V> cn = main.cNode;
            String key = topicLevels.get(levelIndex);
            Branch<V> br = cn.branches().get(key);
            if (br == null) {
                return true;
            }
            if (levelIndex + 1 < topicLevels.size()) {
                if (br.iNode != null) {
                    Frame childTop = new Frame(br.iNode, key, top);
                    return this.remove(br.iNode, i, topicLevels, levelIndex + 1, value, childTop);
                }
                return true;
            }
            if (!br.contains(value)) {
                return true;
            }
            MainNode newMain = this.toContracted(cn.removed(topicLevels.get(levelIndex), value), i);
            if (i.cas(main, newMain)) {
                if (newMain.tNode != null) {
                    this.contractToRoot(top);
                }
                return true;
            }
            return false;
        }
        if (main.tNode != null) {
            if (parent != null) {
                if (top != null && top.keyFromParent != null) {
                    this.clean(parent, top.keyFromParent);
                } else {
                    this.clean(parent);
                }
            }
            return false;
        }
        throw new IllegalStateException("TopicLevelTrie is in an invalid state");
    }

    private void contractToRoot(Frame<V> top) {
        Frame parentF;
        Frame<Object> childF = top;
        while ((parentF = childF.prev) != null) {
            Frame gpF = parentF.prev;
            String branchTopicLevel = gpF == null ? childF.keyFromParent : parentF.keyFromParent;
            this.cleanParent(childF.node, parentF.node, gpF == null ? null : gpF.node, childF.keyFromParent, branchTopicLevel);
            MainNode pAfter = parentF.node.main();
            if (pAfter.tNode != null) {
                childF = parentF;
                continue;
            }
            if (gpF == null) break;
            MainNode gAfter = gpF.node.main();
            if (gAfter.tNode == null) break;
            childF = gpF;
        }
    }

    protected final Set<V> lookup(List<String> topicLevels, BranchSelector branchSelector) {
        LookupResult<V> result;
        do {
            INode<V> r = this.root();
            result = this.lookup(r, null, topicLevels, 0, branchSelector);
        } while (!result.successOrRetry);
        return result.values;
    }

    private LookupResult<V> lookup(INode<V> i, INode<V> parent, List<String> topicLevels, int currentLevel, BranchSelector branchSelector) {
        MainNode<V> main = i.main();
        if (main.cNode != null) {
            CNode cn = main.cNode;
            Map branches = branchSelector.selectBranch(cn.branches(), topicLevels, currentLevel);
            StrategySet<V> values = new StrategySet<V>(this.strategy);
            block4: for (Map.Entry entry : branches.entrySet()) {
                Branch branch = entry.getKey();
                BranchSelector.Action action = entry.getValue();
                switch (action) {
                    case MATCH_AND_CONTINUE: 
                    case CONTINUE: {
                        if (action == BranchSelector.Action.MATCH_AND_CONTINUE) {
                            values.addAll(branch.values());
                        }
                        if (branch.iNode == null) continue block4;
                        LookupResult result = this.lookup(branch.iNode, i, topicLevels, currentLevel + 1, branchSelector);
                        if (result.successOrRetry) {
                            values.addAll(result.values);
                            break;
                        }
                        return result;
                    }
                    case MATCH_AND_STOP: 
                    case STOP: {
                        if (action != BranchSelector.Action.MATCH_AND_STOP) continue block4;
                        values.addAll(branch.values());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown action: " + String.valueOf((Object)action));
                    }
                }
            }
            return new LookupResult<V>(values, true);
        }
        if (main.tNode != null) {
            if (parent != null) {
                this.clean(parent);
            }
            return new LookupResult(null, false);
        }
        throw new IllegalStateException("TopicLevelTrie is in an invalid state");
    }

    INode<V> root() {
        return ROOT_UPDATER.get(this);
    }

    private MainNode<V> toContracted(CNode<V> cn, INode<V> parent) {
        if (this.root() != parent && cn.branchCount() == 0) {
            return new MainNode(new TNode());
        }
        return new MainNode<V>(cn);
    }

    private void clean(INode<V> i) {
        MainNode<V> main = i.main();
        if (main.cNode != null) {
            boolean isRoot;
            CNode compressedCNode = this.toCompressed(main.cNode);
            boolean unchanged = compressedCNode == main.cNode;
            boolean bl = isRoot = this.root() == i;
            if (unchanged && (isRoot || compressedCNode.branchCount() != 0)) {
                return;
            }
            i.cas(main, this.toContracted(compressedCNode, i));
        }
    }

    private void clean(INode<V> i, String onlyKey) {
        MainNode<V> main = i.main();
        if (main.cNode != null) {
            CNode compressed = this.toCompressed(main.cNode, onlyKey);
            if (compressed == main.cNode) {
                return;
            }
            i.cas(main, this.toContracted(compressed, i));
        }
    }

    private void cleanParent(INode<V> i, INode<V> parent, INode<V> grandparent, String topicLevel, String branchTopicLevel) {
        MainNode<V> pMain;
        do {
            MainNode<V> main = i.main();
            pMain = parent.main();
            if (pMain.cNode == null) {
                return;
            }
            Branch br = pMain.cNode.branches().get(topicLevel);
            if (br != null && br.iNode == i && main.tNode != null) continue;
            return;
        } while (!this.contract(i, grandparent, parent, pMain, topicLevel, branchTopicLevel));
    }

    private boolean contract(INode<V> child, INode<V> grandparent, INode<V> parent, MainNode<V> pMain, String topicLevel, String branchTopicLevel) {
        Branch targetChildBranch = pMain.cNode.branches().get(topicLevel);
        if (targetChildBranch == null || targetChildBranch.iNode != child) {
            return true;
        }
        CNode parentAfterDetachChild = this.toCompressed(pMain.cNode.updatedBranch(topicLevel, null, targetChildBranch), topicLevel);
        if (parentAfterDetachChild.branchCount() == 0 && grandparent != null) {
            MainNode<V> gpMain = grandparent.main();
            if (gpMain.cNode == null) {
                return true;
            }
            Branch parentBranch = gpMain.cNode.branches().get(branchTopicLevel);
            if (parentBranch == null || parentBranch.iNode != parent) {
                return true;
            }
            CNode gpAfterDetachParent = this.toCompressed(gpMain.cNode.updatedBranch(branchTopicLevel, null, parentBranch), branchTopicLevel);
            return grandparent.cas(gpMain, this.toContracted(gpAfterDetachParent, grandparent));
        }
        Runnable hook = TestHook.beforeParentContractCas;
        if (hook != null) {
            hook.run();
        }
        return parent.cas(pMain, this.toContracted(parentAfterDetachChild, parent));
    }

    private CNode<V> toCompressed(CNode<V> cn) {
        BranchTable table = cn.table;
        boolean changed = false;
        for (Map.Entry<String, Branch<V>> entry : cn.branches().entrySet()) {
            if (!this.couldTrim(entry.getValue())) continue;
            table = table.minus(entry.getKey());
            changed = true;
        }
        return changed ? new CNode(table, this.strategy) : cn;
    }

    private CNode<V> toCompressed(CNode<V> cn, String onlyKey) {
        Branch<V> br = cn.branches().get(onlyKey);
        if (this.couldTrim(br)) {
            return new CNode(cn.table.minus(onlyKey), this.strategy);
        }
        return cn;
    }

    private boolean couldTrim(Branch<V> br) {
        if (br == null) {
            return false;
        }
        if (!br.values.isEmpty()) {
            return false;
        }
        if (br.iNode == null) {
            return true;
        }
        MainNode main = br.iNode.main();
        return main.tNode != null;
    }

    @Generated
    public String toString() {
        return "TopicLevelTrie(strategy=" + String.valueOf(this.strategy) + ", root=" + String.valueOf(this.root) + ")";
    }

    private static final class Frame<T> {
        final INode<T> node;
        final String keyFromParent;
        final Frame<T> prev;

        Frame(INode<T> node, String keyFromParent, Frame<T> prev) {
            this.node = node;
            this.keyFromParent = keyFromParent;
            this.prev = prev;
        }
    }

    public static interface BranchSelector {
        public <V> Map<Branch<V>, Action> selectBranch(Map<String, Branch<V>> var1, List<String> var2, int var3);

        public static enum Action {
            STOP,
            CONTINUE,
            MATCH_AND_CONTINUE,
            MATCH_AND_STOP;

        }
    }

    private record LookupResult<V>(Set<V> values, boolean successOrRetry) {
    }

    static final class TestHook {
        static volatile Runnable beforeParentContractCas;

        private TestHook() {
        }
    }
}

