/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.messenger;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Timed;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.messenger.MessengerMessageEnvelope;
import org.apache.bifromq.basecluster.messenger.proto.MessengerMessage;
import org.apache.bifromq.basecluster.transport.ITransport;
import org.apache.bifromq.basecluster.transport.PacketEnvelope;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessengerTransport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessengerTransport.class);
    private final ITransport transport;

    MessengerTransport(ITransport transport) {
        this.transport = transport;
    }

    InetSocketAddress bindAddress() {
        return this.transport.bindAddress();
    }

    CompletableFuture<Void> send(List<MessengerMessage> messengerMessages, InetSocketAddress recipient, boolean forceTCP) {
        ITransport.RELIABLE.set(forceTCP);
        return this.transport.send(messengerMessages.stream().map(AbstractMessageLite::toByteString).collect(Collectors.toList()), recipient);
    }

    Observable<Timed<MessengerMessageEnvelope>> receive() {
        return this.transport.receive().flatMap(this::convert);
    }

    private Observable<Timed<MessengerMessageEnvelope>> convert(PacketEnvelope packetEnvelope) {
        return Observable.fromIterable((Iterable)packetEnvelope.data.stream().map(b -> {
            try {
                MessengerMessage msg = (MessengerMessage)ZeroCopyParser.parse((ByteString)b, MessengerMessage.parser());
                MessengerMessageEnvelope mmEnvelop = MessengerMessageEnvelope.builder().recipient(packetEnvelope.recipient).message(msg).sender(packetEnvelope.sender).build();
                return new Timed((Object)mmEnvelop, System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InvalidProtocolBufferException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

