/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallExecutorSupplier;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.baserpc.server.IRPCServer;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.baserpc.server.interceptor.TenantAwareServerInterceptor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceServerRegister;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RPCServer
implements IRPCServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCServer.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final IRPCServiceTrafficService trafficService;
    private final String id;
    private final Map<String, RPCServerBuilder.ServiceDefinition> serviceDefinitions;
    private final Map<String, IRPCServiceServerRegister.IServerRegistration> registrations = new HashMap<String, IRPCServiceServerRegister.IServerRegistration>();
    private final EventLoopGroup bossEventLoopGroup;
    private final EventLoopGroup workerEventLoopGroup;
    private final Server inProcServer;
    private final Server interProcServer;

    RPCServer(RPCServerBuilder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.host) && !"0.0.0.0".equals(builder.host) ? 1 : 0) != 0, (Object)"Invalid host");
        Preconditions.checkArgument((!builder.serviceDefinitions.isEmpty() ? 1 : 0) != 0, (Object)"No service defined");
        this.id = builder.id;
        this.trafficService = builder.trafficService;
        this.serviceDefinitions = builder.serviceDefinitions;
        ServerBuilder serverBuilder = InProcessServerBuilder.forName((String)this.id).callExecutor(new ServerCallExecutorSupplier(){

            public <ReqT, RespT> Executor getExecutor(ServerCall<ReqT, RespT> call, Metadata metadata) {
                return RPCServer.this.serviceDefinitions.get(call.getMethodDescriptor().getServiceName()).executor();
            }
        });
        this.bindServiceToServer(serverBuilder);
        this.inProcServer = serverBuilder.build();
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(builder.host, builder.port)).permitKeepAliveWithoutCalls(true).maxInboundMessageSize(Integer.MAX_VALUE).callExecutor(new ServerCallExecutorSupplier(){

            public <ReqT, RespT> Executor getExecutor(ServerCall<ReqT, RespT> call, Metadata metadata) {
                return RPCServer.this.serviceDefinitions.get(call.getMethodDescriptor().getServiceName()).executor();
            }
        });
        if (builder.sslContext != null) {
            nettyServerBuilder.sslContext(builder.sslContext);
        }
        this.bossEventLoopGroup = NettyEnv.createEventLoopGroup((int)1, (String)"rpc-server-boss-elg");
        new NettyEventExecutorMetrics((Iterable)this.bossEventLoopGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        this.workerEventLoopGroup = NettyEnv.createEventLoopGroup((int)builder.workerThreads, (String)"rpc-server-worker-elg");
        new NettyEventExecutorMetrics((Iterable)this.workerEventLoopGroup).bindTo((MeterRegistry)Metrics.globalRegistry);
        nettyServerBuilder.bossEventLoopGroup(this.bossEventLoopGroup).workerEventLoopGroup(this.workerEventLoopGroup).channelType(NettyEnv.determineServerSocketChannelClass((EventLoopGroup)this.bossEventLoopGroup));
        this.bindServiceToServer((ServerBuilder<?>)nettyServerBuilder);
        this.interProcServer = nettyServerBuilder.build();
    }

    private void bindServiceToServer(ServerBuilder<?> builder) {
        this.serviceDefinitions.forEach((serviceUniqueName, def) -> {
            ServerServiceDefinition.Builder serverDefBuilder = ServerServiceDefinition.builder((String)def.definition().getServiceDescriptor().getName());
            for (ServerMethodDefinition serverMethodDef : def.definition().getMethods()) {
                MethodDescriptor methodDesc = def.bluePrint().methodDesc(serverMethodDef.getMethodDescriptor().getFullMethodName());
                if (methodDesc != null) {
                    serverDefBuilder.addMethod(methodDesc, serverMethodDef.getServerCallHandler());
                    continue;
                }
                serverDefBuilder.addMethod(serverMethodDef);
            }
            ServerServiceDefinition serviceDef = serverDefBuilder.build();
            builder.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])new ServerInterceptor[]{new TenantAwareServerInterceptor(serviceDef, def.bluePrint())}));
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public final void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                this.inProcServer.start();
                this.interProcServer.start();
                InetSocketAddress serverAddr = (InetSocketAddress)this.interProcServer.getListenSockets().get(0);
                this.serviceDefinitions.forEach((serviceUniqueName, def) -> {
                    log.debug("Start server register for service: {}", serviceUniqueName);
                    this.registrations.put((String)serviceUniqueName, this.trafficService.getServerRegister(serviceUniqueName).reg(this.id, serverAddr, def.defaultGroupTags(), def.attributes()));
                });
                this.state.set(State.STARTED);
            }
            catch (IOException e) {
                this.state.set(State.FATAL_FAILURE);
                throw new IllegalStateException("Unable to start rpc server", e);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                this.registrations.forEach((serviceUniqueName, registration) -> {
                    log.debug("Stop server register for service: {}", serviceUniqueName);
                    registration.stop();
                });
                log.debug("Stopping inter-proc server");
                this.shutdownInternalServer(this.interProcServer);
                log.debug("Stopping in-proc server");
                this.shutdownInternalServer(this.inProcServer);
                this.bossEventLoopGroup.shutdownGracefully().sync();
                this.workerEventLoopGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.state.set(State.STOPPED);
            }
        }
    }

    private void shutdownInternalServer(Server server) {
        server.shutdown();
        try {
            server.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        server.shutdownNow();
        server.awaitTermination();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FATAL_FAILURE;

    }
}

